/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.jms.JMSAcknowledgePoint;
import com.ibm.jms.JMSBytesMessage;
import com.ibm.jms.JMSDestination;
import com.ibm.jms.JMSDestinationFactory;
import com.ibm.jms.JMSMapMessage;
import com.ibm.jms.JMSMessage;
import com.ibm.jms.JMSNullMessage;
import com.ibm.jms.JMSObjectMessage;
import com.ibm.jms.JMSStreamMessage;
import com.ibm.jms.JMSStringResources;
import com.ibm.jms.JMSTextMessage;
import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQMsg2;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.MQSPIQueueManager;
import com.ibm.mq.jms.BrokerConnectionInfo;
import com.ibm.mq.jms.JMSServicesMgr;
import com.ibm.mq.jms.MQBrokerSubscriptionEngine;
import com.ibm.mq.jms.MQConnection;
import com.ibm.mq.jms.MQDestination;
import com.ibm.mq.jms.MQJMSMessage;
import com.ibm.mq.jms.MQJMSStringResources;
import com.ibm.mq.jms.MQMessageConsumer;
import com.ibm.mq.jms.MQMessageProducer;
import com.ibm.mq.jms.MQMessageReference;
import com.ibm.mq.jms.MQMessageSelector;
import com.ibm.mq.jms.MQMigrateSubscriptionEngine;
import com.ibm.mq.jms.MQQueueBrowser;
import com.ibm.mq.jms.MQQueueReceiver;
import com.ibm.mq.jms.MQQueueSender;
import com.ibm.mq.jms.MQSubscription;
import com.ibm.mq.jms.MQSubscriptionEngine;
import com.ibm.mq.jms.MQTemporaryQueue;
import com.ibm.mq.jms.MQTemporaryTopic;
import com.ibm.mq.jms.MQTopic;
import com.ibm.mq.jms.MQTopicPublisher;
import com.ibm.mq.jms.MQTopicSubscriber;
import com.ibm.mq.jms.MessageReference;
import com.ibm.mq.jms.SessionAsyncHelper;
import com.ibm.mq.jms.SessionClosedException;
import com.ibm.mq.jms.SyntaxException;
import com.ibm.mq.jms.Utils;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Logger;
import com.ibm.mq.jms.services.Trace;
import com.ibm.mq.jms.services.psk.LogException;
import com.ibm.mq.jms.services.psk.LogMessage;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import javax.jms.TransactionRolledBackException;

public class MQSession
implements Session,
JMSAcknowledgePoint,
JMSDestinationFactory {
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26 (c) Copyright IBM Corp. 1999, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) jms/com/ibm/mq/jms/MQSession.java, jms, j600, j600-101-060328 1.174.1.7 06/01/13 10:20:40";
    private static final int STATE_STOPPED = 0;
    private static final int STATE_STARTED = 1;
    private static final int STATE_CLOSED = 2;
    static final JMSStringResources jmsStrings = new MQJMSStringResources();
    static final int DIST_TRAN_NONE = 0;
    static final int DIST_TRAN_XA = 1;
    static final int DIST_TRAN_RRS = 2;
    protected boolean transacted;
    protected int acknowledgeMode;
    protected int distTransactionMode;
    MQQueueManager qm;
    protected int state;
    private Object transactionLock;
    protected Vector messageProducers;
    protected Vector messageConsumers;
    protected Vector messages;
    protected String messageQueueName;
    protected MessageListener messageListener;
    protected SessionAsyncHelper asyncHelper;
    private boolean playNice;
    protected boolean useSPIP;
    private Object stateChangeSem;
    protected boolean persistenceFromMD;
    private MQQueue cbInputQueue;
    private String lastQueueName;
    protected static final int DEFAULT_BROKER_TIMEOUT = 120000;
    protected static final int MIN_CLEANUP_TIME = 59000;
    static final int REGISTER_PUBLISHER = 0;
    static final int DEREGISTER_PUBLISHER = 1;
    static final int REGISTER_SUBSCRIBER = 2;
    static final int DEREGISTER_SUBSCRIBER = 3;
    static final int REGISTER_SHAREDQ_SUBSCRIBER = 4;
    static final int DEREGISTER_SHAREDQ_SUBSCRIBER = 5;
    protected static final String REGPUB_CMD_PREFIX = "MQPSCommand RegPub MQPSTopic ";
    protected static final String DEREGPUB_CMD_PREFIX = "MQPSCommand DeregPub MQPSTopic ";
    protected static final String REGSUB_CMD_PREFIX = "MQPSCommand RegSub MQPSTopic ";
    protected static final String DEREGSUB_CMD_PREFIX = "MQPSCommand DeregSub MQPSTopic ";
    protected static final String REGSUB_CORREL_CMD_PREFIX = "MQPSCommand RegSub MQPSRegOpts CorrelAsId MQPSTopic ";
    protected static final String DEREGSUB_CORREL_CMD_PREFIX = "MQPSCommand DeregSub MQPSRegOpts CorrelAsId MQPSTopic ";
    protected static final String MQPS_STREAM_NAME_B = " MQPSStreamName ";
    protected static final String MQPS_Q_NAME_B = " MQPSQName ";
    protected static final String MQPS_REGISTRATION_OPTIONS_B = " MQPSRegOpts ";
    protected static final String MQPS_NON_PERSISTENT = "NonPers";
    protected static final String MQPS_DUPLICATES_OK = "DupsOK";
    static final int MQCA_QSG_NAME = 2040;
    static final String PUBLISH_CMD_PREFIX = "MQPSCommand Publish MQPSTopic ";
    protected boolean wait_for_reply;
    boolean mapNameStyle;
    protected int brokerTimeout;
    protected BrokerConnectionInfo brk;
    protected MQConnection connection;
    protected String deadLetterQueue;
    protected String resolvedQmName;
    protected String resolvedQSGName;
    protected String nondur_subscribeQ;
    String SUBSCRIBE_CMD_POSTFIX;
    protected MQQueue replyQ;
    MQGetMessageOptions brokerReponseGmo;
    protected byte[] responseCorrelId;
    protected boolean responseOnCommit;
    protected boolean responseRequested;
    protected int responseInterval;
    protected int checkInterval;
    protected int publishCount;
    protected long responsePutTime;
    protected int brkOptLevel;
    protected byte[] sessionName;
    protected String dynamicQName;
    protected int receiveIsolation;
    protected boolean outcomeNotification;
    protected int processDuration;
    protected boolean optimisticPublication;
    protected boolean commitRequired;
    private JMSServicesMgr mqServices;
    protected boolean pubsubInit;
    private boolean ITXSupported;
    private boolean ITXSupportChecked;

    MQSession(MQConnection mQConnection, boolean bl, int n) {
        block18: {
            this.distTransactionMode = 0;
            this.qm = null;
            this.state = 0;
            this.transactionLock = new Object();
            this.messageProducers = new Vector();
            this.messageConsumers = new Vector();
            this.asyncHelper = null;
            this.playNice = false;
            this.stateChangeSem = new Object();
            this.cbInputQueue = null;
            this.lastQueueName = null;
            this.wait_for_reply = true;
            this.mapNameStyle = true;
            this.brokerTimeout = 120000;
            this.brk = new BrokerConnectionInfo(null, null, null);
            this.connection = null;
            this.deadLetterQueue = null;
            this.resolvedQmName = null;
            this.resolvedQSGName = null;
            this.replyQ = null;
            this.responseCorrelId = new byte[24];
            this.responseOnCommit = false;
            this.responseRequested = false;
            this.responseInterval = 0;
            this.checkInterval = 0;
            this.publishCount = 0;
            this.responsePutTime = 0L;
            this.dynamicQName = null;
            this.receiveIsolation = 0;
            this.outcomeNotification = true;
            this.processDuration = 0;
            this.optimisticPublication = false;
            this.commitRequired = false;
            this.mqServices = null;
            this.pubsubInit = false;
            this.ITXSupported = false;
            this.ITXSupportChecked = false;
            Trace.checkForTurnTracingOn();
            if (Trace.isOn) {
                Trace.entry(this, "MQSession constructor(connection, transacted, acknowledgeMode)");
                Trace.trace(this, sccsid);
            }
            try {
                int n2;
                this.connection = mQConnection;
                this.transacted = bl;
                this.acknowledgeMode = n;
                this.persistenceFromMD = mQConnection != null ? mQConnection.getPersistenceFromMD() : false;
                if (Trace.isOn) {
                    Trace.trace(this, "Resolving QMName");
                }
                if (mQConnection.qm != null) {
                    try {
                        n2 = 2015;
                        this.resolvedQmName = mQConnection.qm.getAttributeString(n2, 48).trim();
                    }
                    catch (Exception exception) {
                        this.resolvedQmName = mQConnection.qm.name;
                    }
                } else if (mQConnection.qmgrName != null) {
                    this.resolvedQmName = mQConnection.qmgrName;
                }
                if (Trace.isOn) {
                    Trace.trace(this, "Resolving QSGName");
                }
                if (mQConnection.qm != null) {
                    try {
                        n2 = 2040;
                        this.resolvedQSGName = mQConnection.qm.getAttributeString(n2, 4).trim();
                    }
                    catch (Exception exception) {
                        this.resolvedQSGName = null;
                        if (Trace.isOn) {
                            Trace.trace(this, "Setting QSGName to null");
                        }
                    }
                } else {
                    this.resolvedQSGName = null;
                    if (Trace.isOn) {
                        Trace.trace(this, "No qm, setting QSGName to null");
                    }
                }
                if (Trace.isOn) {
                    Trace.trace(this, "QSGName set to " + this.resolvedQSGName);
                }
                MQException.log = null;
                if (Trace.isOn) {
                    Trace.exit(this, "MQSession constructor(connection, transacted, acknowledgeMode)");
                }
            }
            catch (Exception exception) {
                if (!Trace.isOn) break block18;
                Trace.trace(this, "Exception thrown in constructor");
                Trace.exception(this, "constructor(connection, transacted, acknowledgeMode)", (Throwable)exception);
            }
        }
    }

    MQSession(MQConnection mQConnection, MQQueueManager mQQueueManager, boolean bl, int n) throws JMSException {
        block12: {
            int n2;
            this(mQConnection, bl, n);
            if (Trace.isOn) {
                Trace.entry(this, "constructor");
                Trace.trace(this, sccsid);
            }
            this.qm = mQQueueManager;
            this.connection = mQConnection;
            MQSubscriptionEngine mQSubscriptionEngine = this.connection.getSubscriptionEngine();
            this.sessionName = null;
            if (mQSubscriptionEngine instanceof MQBrokerSubscriptionEngine) {
                this.sessionName = ((MQBrokerSubscriptionEngine)mQSubscriptionEngine).createSessionName(this);
            } else if (mQSubscriptionEngine instanceof MQMigrateSubscriptionEngine) {
                this.sessionName = ((MQMigrateSubscriptionEngine)mQSubscriptionEngine).createSessionName(this);
            }
            this.brk.controlQ = this.connection.getBrkControlQueue();
            this.brk.streamQ = this.connection.getBrkPubQueue();
            this.brk.qmName = this.connection.getBrkQueueManager();
            this.brkOptLevel = this.connection.getBrkOptLevel();
            this.nondur_subscribeQ = this.connection.getBrkSubQueue();
            this.mapNameStyle = this.connection.getMapNameStyle();
            this.SUBSCRIBE_CMD_POSTFIX = new String(MQPS_STREAM_NAME_B + this.brk.streamQ + MQPS_Q_NAME_B);
            this.responseInterval = this.connection.getPubAckInterval();
            this.checkInterval = this.responseInterval / 2;
            this.receiveIsolation = this.connection.getReceiveIsolation();
            this.processDuration = this.connection.getProcessDuration();
            this.outcomeNotification = this.connection.getOutcomeNotification();
            this.optimisticPublication = this.connection.getOptimisticPublication();
            int n3 = 1;
            if (mQConnection.getFailIfQuiesce() == 1) {
                n3 |= 0x2000;
            }
            this.brokerReponseGmo = new MQGetMessageOptions();
            this.brokerReponseGmo.options = 1;
            this.brokerReponseGmo.waitInterval = this.brokerTimeout;
            if (mQConnection.getFailIfQuiesce() == 1) {
                this.brokerReponseGmo.options |= 0x2000;
            }
            try {
                n2 = 2015;
                this.resolvedQmName = mQQueueManager.getAttributeString(n2, 48).trim();
            }
            catch (Exception exception) {
                this.resolvedQmName = mQQueueManager.name;
            }
            try {
                n2 = 2040;
                this.resolvedQSGName = mQQueueManager.getAttributeString(n2, 4).trim();
            }
            catch (Exception exception) {
                this.resolvedQSGName = null;
                if (!Trace.isOn) break block12;
                Trace.trace(this, "Setting QSGName to null");
            }
        }
        if (Trace.isOn) {
            Trace.trace(this, "QSGName set to " + this.resolvedQSGName);
        }
        if (Trace.isOn) {
            Trace.exit(this, "constructor");
        }
    }

    MQSession(MQQueueManager mQQueueManager, String string, String string2) throws JMSException {
        block18: {
            this.distTransactionMode = 0;
            this.qm = null;
            this.state = 0;
            this.transactionLock = new Object();
            this.messageProducers = new Vector();
            this.messageConsumers = new Vector();
            this.asyncHelper = null;
            this.playNice = false;
            this.stateChangeSem = new Object();
            this.cbInputQueue = null;
            this.lastQueueName = null;
            this.wait_for_reply = true;
            this.mapNameStyle = true;
            this.brokerTimeout = 120000;
            this.brk = new BrokerConnectionInfo(null, null, null);
            this.connection = null;
            this.deadLetterQueue = null;
            this.resolvedQmName = null;
            this.resolvedQSGName = null;
            this.replyQ = null;
            this.responseCorrelId = new byte[24];
            this.responseOnCommit = false;
            this.responseRequested = false;
            this.responseInterval = 0;
            this.checkInterval = 0;
            this.publishCount = 0;
            this.responsePutTime = 0L;
            this.dynamicQName = null;
            this.receiveIsolation = 0;
            this.outcomeNotification = true;
            this.processDuration = 0;
            this.optimisticPublication = false;
            this.commitRequired = false;
            this.mqServices = null;
            this.pubsubInit = false;
            this.ITXSupported = false;
            this.ITXSupportChecked = false;
            if (Trace.isOn) {
                Trace.entry(this, "constructor (qm, controlQName, streamQName");
                Trace.trace(this, sccsid);
            }
            try {
                int n;
                this.connection = null;
                this.transacted = false;
                this.acknowledgeMode = 1;
                this.persistenceFromMD = false;
                if (Trace.isOn) {
                    Trace.trace(this, "Resolving QMName");
                }
                if (mQQueueManager != null) {
                    try {
                        n = 2015;
                        this.resolvedQmName = mQQueueManager.getAttributeString(n, 48).trim();
                    }
                    catch (Exception exception) {
                        this.resolvedQmName = mQQueueManager.name;
                    }
                } else {
                    this.resolvedQmName = mQQueueManager.name;
                }
                if (Trace.isOn) {
                    Trace.trace(this, "Resolving QSGName");
                }
                if (mQQueueManager != null) {
                    try {
                        n = 2040;
                        this.resolvedQSGName = mQQueueManager.getAttributeString(n, 4).trim();
                    }
                    catch (Exception exception) {
                        this.resolvedQSGName = null;
                        if (Trace.isOn) {
                            Trace.trace(this, "Setting QSGName to null");
                        }
                    }
                } else {
                    this.resolvedQSGName = null;
                    if (Trace.isOn) {
                        Trace.trace(this, "No qm, setting QSGName to null");
                    }
                }
                if (Trace.isOn) {
                    Trace.trace(this, "QSGName set to" + this.resolvedQSGName);
                }
                MQException.log = null;
                if (Trace.isOn) {
                    Trace.exit(this, "MQSession constructor(connection, transacted, acknowledgeMode)");
                }
            }
            catch (Exception exception) {
                if (!Trace.isOn) break block18;
                Trace.trace(this, "Exception thrown in constructor");
                Trace.exception(this, "constructor(connection, transacted, acknowledgeMode)", (Throwable)exception);
            }
        }
        this.qm = mQQueueManager;
        this.brk.controlQ = string;
        this.brk.streamQ = string2;
        this.SUBSCRIBE_CMD_POSTFIX = new String(MQPS_STREAM_NAME_B + this.brk.streamQ + MQPS_Q_NAME_B);
        if (Trace.isOn) {
            Trace.exit(this, "constructor");
        }
    }

    public void finalize() throws Throwable {
        if (Trace.isOn) {
            Trace.entry(this, "finalize");
        }
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.finalize();
        if (Trace.isOn) {
            Trace.exit(this, "finalize");
        }
    }

    public void commit() throws JMSException {
        if (this.getServicesMgr().queueSet) {
            this.commitQ();
        }
        if (this.getServicesMgr().pubSubSet) {
            this.commitT();
        } else {
            if (this.isClosed()) {
                String string = "MQJMS1024";
                String string2 = ConfigEnvironment.getErrorMessage(string);
                IllegalStateException illegalStateException = new IllegalStateException(string2, string);
                throw illegalStateException;
            }
            if (!this.transacted) {
                String string = "MQJMS1019";
                String string3 = ConfigEnvironment.getErrorMessage(string);
                IllegalStateException illegalStateException = new IllegalStateException(string3, string);
                throw illegalStateException;
            }
            if (this.qm == null) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS2004");
                throw jMSException;
            }
        }
    }

    public void recover() throws JMSException {
        if (this.getServicesMgr().queueSet) {
            this.recoverQ();
        }
        if (this.getServicesMgr().pubSubSet) {
            this.recoverT();
        } else {
            if (this.isClosed()) {
                String string = "MQJMS1024";
                String string2 = ConfigEnvironment.getErrorMessage(string);
                IllegalStateException illegalStateException = new IllegalStateException(string2, string);
                throw illegalStateException;
            }
            if (this.transacted) {
                String string = "MQJMS1020";
                String string3 = ConfigEnvironment.getErrorMessage(string);
                IllegalStateException illegalStateException = new IllegalStateException(string3, string);
                throw illegalStateException;
            }
            if (this.qm == null) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS2004");
                throw jMSException;
            }
        }
    }

    public void rollback() throws JMSException {
        if (this.getServicesMgr().queueSet) {
            this.rollbackQ();
        }
        if (this.getServicesMgr().pubSubSet) {
            this.rollbackT();
        } else {
            if (this.isClosed()) {
                String string = "MQJMS1024";
                String string2 = ConfigEnvironment.getErrorMessage(string);
                IllegalStateException illegalStateException = new IllegalStateException(string2, string);
                throw illegalStateException;
            }
            if (!this.transacted) {
                String string = "MQJMS1019";
                String string3 = ConfigEnvironment.getErrorMessage(string);
                IllegalStateException illegalStateException = new IllegalStateException(string3, string);
                throw illegalStateException;
            }
            if (this.qm == null) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS2004");
                throw jMSException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deliver(Vector vector) {
        if (Trace.isOn) {
            Trace.entry(this, "deliver");
        }
        try {
            Enumeration enumeration = vector.elements();
            MQSession mQSession = this;
            synchronized (mQSession) {
                if (this.messages == null) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Taking ownership of the messageList");
                    }
                } else {
                    if (Trace.isOn) {
                        Trace.trace(this, "Session already contains messages");
                    }
                    throw new JMSException("Session already contains messages");
                }
                this.messages = vector;
            }
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.exception(this, "deliver", (Throwable)jMSException);
            }
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "deliver");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws JMSException {
        block49: {
            try {
                Object object;
                if (Trace.isOn) {
                    Trace.entry(this, "close");
                }
                if (this.getServicesMgr() != null && this.getServicesMgr().pubSubSet) {
                    this.closeT();
                }
                if (this.state == 1 || this.state == 0) {
                    block48: {
                        if (this.getAcknowledgeMode() == 1 || this.getAcknowledgeMode() == 3) {
                            try {
                                this._acknowledge(true);
                            }
                            catch (Exception exception) {
                                if (!Trace.isOn) break block48;
                                Trace.trace(this, "_acknowledge() from close() failed : Not throwing Exception");
                            }
                        }
                    }
                    this.state = 2;
                    object = this.stateChangeSem;
                    synchronized (object) {
                        this.stateChangeSem.notifyAll();
                    }
                    if (this.connection != null) {
                        this.connection.removeSession(this);
                    }
                } else if (this.state != 2) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1005", String.valueOf(this.state), "STATE_CLOSED");
                    throw jMSException;
                }
                if (this.asyncHelper != null) {
                    this.asyncHelper.shutdown();
                    this.asyncHelper = null;
                }
                if (this.qm != null) {
                    if (this.distTransactionMode == 0 || this.distTransactionMode == 2 && !Utils.isRRSTransactionInProgress()) {
                        try {
                            if (Trace.isOn) {
                                Trace.trace(this, "backing out queueManager");
                            }
                            this.qm.backout();
                        }
                        catch (MQException mQException) {
                            if (Trace.isOn) {
                                Trace.trace(this, "backout failed with " + mQException);
                            }
                            switch (mQException.reasonCode) {
                                case 2071: 
                                case 2102: 
                                case 2124: 
                                case 2195: 
                                case 2219: {
                                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1032", mQException.getMessage());
                                    jMSException.setLinkedException((Exception)mQException);
                                    throw jMSException;
                                }
                                case 2009: 
                                case 2012: 
                                case 2018: 
                                case 2019: 
                                case 2101: 
                                case 2123: 
                                case 2130: 
                                case 2157: 
                                case 2162: {
                                    try {
                                        Logger.log(new LogMessage(2, "MQJMS1023"));
                                    }
                                    catch (LogException logException) {
                                        System.err.println("failed to log error because of " + logException);
                                    }
                                    break;
                                }
                                default: {
                                    try {
                                        Logger.log(new LogMessage(2, "MQJMS1016", mQException.toString()));
                                    }
                                    catch (LogException logException) {
                                        System.err.println("failed to log error because of " + logException);
                                    }
                                    break;
                                }
                            }
                        }
                    } else if (Trace.isOn) {
                        if (this.distTransactionMode == 1) {
                            Trace.trace(this, "not calling qm.backout since we are under XA");
                        } else {
                            Trace.trace(this, "not calling qm.backout since an RRS global transaction is in progress");
                        }
                    }
                }
                object = this.getTransactionLock();
                synchronized (object) {
                    this.closeAllChildren();
                }
                if (this.qm == null) break block49;
                if (this.distTransactionMode == 1) {
                    Trace.trace(this, "qm.disc postponed because this session is XA aware");
                    break block49;
                }
                try {
                    Trace.trace(this, "disconnecting queueManager");
                    this.qm.disconnect();
                }
                catch (Exception exception) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS2003");
                    jMSException.setLinkedException(exception);
                    throw jMSException;
                }
                finally {
                    this.qm = null;
                }
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                    Exception exception = jMSException.getLinkedException();
                    if (exception != null) {
                        Trace.trace(this, "linked exception: " + exception);
                    }
                }
                throw jMSException;
            }
            finally {
                if (Trace.isOn) {
                    Trace.exit(this, "close");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BytesMessage createBytesMessage() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createBytesMessage");
            }
            this.checkSessionOpen();
            JMSBytesMessage jMSBytesMessage = new JMSBytesMessage(jmsStrings);
            return jMSBytesMessage;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createBytesMessage");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JMSDestination createDestination(String string) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createDestination");
            }
            JMSDestination jMSDestination = (JMSDestination)MQDestination.createDestination(string);
            return jMSDestination;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createDestination");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapMessage createMapMessage() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createMapMessage");
            }
            this.checkSessionOpen();
            JMSMapMessage jMSMapMessage = new JMSMapMessage(jmsStrings);
            jMSMapMessage.mapNameStyle = this.mapNameStyle;
            JMSMapMessage jMSMapMessage2 = jMSMapMessage;
            return jMSMapMessage2;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createMapMessage");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message createMessage() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createMessage");
            }
            this.checkSessionOpen();
            JMSNullMessage jMSNullMessage = new JMSNullMessage(jmsStrings);
            return jMSNullMessage;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createMessage");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectMessage createObjectMessage() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createObjectMessage");
            }
            this.checkSessionOpen();
            JMSObjectMessage jMSObjectMessage = new JMSObjectMessage(jmsStrings);
            return jMSObjectMessage;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createObjectMessage");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectMessage createObjectMessage(Serializable serializable) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createObjectMessage(object)");
            }
            this.checkSessionOpen();
            JMSObjectMessage jMSObjectMessage = new JMSObjectMessage(jmsStrings, serializable);
            return jMSObjectMessage;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createObjectMessage(object)");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamMessage createStreamMessage() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createStreamMessage");
            }
            this.checkSessionOpen();
            JMSStreamMessage jMSStreamMessage = new JMSStreamMessage(jmsStrings);
            return jMSStreamMessage;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createStreamMessage");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextMessage createTextMessage() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createTextMessage");
            }
            this.checkSessionOpen();
            JMSTextMessage jMSTextMessage = new JMSTextMessage(jmsStrings);
            return jMSTextMessage;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createTextMessage");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextMessage createTextMessage(String string) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createTextMessage(stringBuffer)");
            }
            this.checkSessionOpen();
            JMSTextMessage jMSTextMessage = new JMSTextMessage(jmsStrings, string);
            return jMSTextMessage;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createTextMessage(stringBuffer)");
            }
        }
    }

    public boolean getTransacted() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getTransacted");
            }
            this.checkSessionOpen();
            switch (this.distTransactionMode) {
                case 0: 
                case 1: {
                    boolean bl = this.transacted;
                    return bl;
                }
                case 2: {
                    boolean bl = this.transacted || Utils.isRRSTransactionInProgress();
                    return bl;
                }
            }
            try {
                if (Trace.isOn) {
                    Trace.trace(this, "Bad distributed transactional mode " + this.distTransactionMode);
                }
                throw ConfigEnvironment.newException("MQJMS1016");
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                    Exception exception = jMSException.getLinkedException();
                    if (exception != null) {
                        Trace.trace(this, "linked excpetion: " + exception);
                    }
                }
                throw jMSException;
            }
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "getTransacted");
            }
        }
    }

    public MessageListener getMessageListener() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "getMessageListener");
        }
        this.checkSessionOpen();
        if (Trace.isOn) {
            Trace.exit(this, "getMessageListener");
        }
        return this.messageListener;
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "setMessageListener");
        }
        try {
            this.checkSessionOpen();
            if (messageListener != null && this.usingAsyncMode()) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1013");
                throw jMSException;
            }
            this.messageListener = messageListener;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "setMessageListener");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block43: {
            if (Trace.isOn) {
                Trace.entry(this, "run");
            }
            Message message = null;
            boolean bl = false;
            try {
                bl = this.getTransacted();
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.exception(this, "run", (Throwable)jMSException);
                }
                this.messages = null;
            }
            this.useSPIP = !bl && this.acknowledgeMode != 2 && !this.getSyncpointAllGets();
            boolean bl2 = false;
            boolean bl3 = true;
            try {
                block42: {
                    if (this.messages != null && this.messageListener != null && this.qm != null) {
                        Enumeration enumeration = this.messages.elements();
                        while (enumeration.hasMoreElements()) {
                            MQMessageReference mQMessageReference = (MQMessageReference)enumeration.nextElement();
                            boolean bl4 = false;
                            try {
                                bl4 = !bl2;
                                bl2 = true;
                                message = this.consume(mQMessageReference);
                                MQJMSMessage mQJMSMessage = mQMessageReference.getMQJMSMessage();
                                if (message == null) {
                                    if (bl4 && bl2) {
                                        bl2 = false;
                                    }
                                } else if (mQJMSMessage != null && this.useSPIP && bl4 && mQJMSMessage.getPersistence() == 0) {
                                    bl2 = false;
                                }
                            }
                            catch (JMSException jMSException) {
                                if (Trace.isOn) {
                                    Trace.exception(this, "run", (Throwable)jMSException);
                                }
                                bl3 = false;
                                this.connection.deliverException(jMSException);
                            }
                            if (bl3 && message != null) {
                                if (Trace.isOn) {
                                    Trace.trace(this, "calling listener");
                                }
                                try {
                                    this.messageListener.onMessage(message);
                                }
                                catch (RuntimeException runtimeException) {
                                    block41: {
                                        if (Trace.isOn) {
                                            Trace.exception(this, "run", (Throwable)runtimeException);
                                        }
                                        if (!bl && this.acknowledgeMode != 2) {
                                            try {
                                                this.qm.backout();
                                                bl2 = false;
                                            }
                                            catch (MQException mQException) {
                                                if (!Trace.isOn) break block41;
                                                Trace.exception(this, "run", (Throwable)mQException);
                                            }
                                        }
                                    }
                                    throw runtimeException;
                                }
                                finally {
                                    if (Trace.isOn) {
                                        Trace.trace(this, "returned from listener");
                                    }
                                }
                            }
                            if (!bl3 || bl || this.acknowledgeMode != 1 || !bl2) continue;
                            try {
                                this.qm.commit();
                                bl2 = false;
                            }
                            catch (MQException mQException) {
                                if (!Trace.isOn) continue;
                                Trace.exception(this, "run", (Throwable)mQException);
                            }
                        }
                        if (bl3 && !bl && this.acknowledgeMode == 3 && bl2) {
                            try {
                                this.qm.commit();
                                bl2 = false;
                            }
                            catch (MQException mQException) {
                                if (!Trace.isOn) break block42;
                                Trace.exception(this, "run", (Throwable)mQException);
                            }
                        }
                    }
                }
                Object var12_16 = null;
                this.messages = null;
                if (bl || this.acknowledgeMode == 2 || !bl2) break block43;
            }
            catch (Throwable throwable) {
                block44: {
                    Object var12_17 = null;
                    this.messages = null;
                    if (!bl && this.acknowledgeMode != 2 && bl2) {
                        try {
                            if (this.qm != null) {
                                this.qm.backout();
                            }
                        }
                        catch (MQException mQException) {
                            if (!Trace.isOn) break block44;
                            Trace.exception(this, "run", (Throwable)mQException);
                        }
                    }
                }
                if (Trace.isOn) {
                    Trace.exit(this, "run");
                }
                throw throwable;
            }
            try {
                if (this.qm != null) {
                    this.qm.backout();
                }
            }
            catch (MQException mQException) {
                if (!Trace.isOn) break block43;
                Trace.exception(this, "run", (Throwable)mQException);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "run");
        }
    }

    public void _acknowledge(boolean bl) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "_acknowledge");
            }
            if (this.isClosed()) {
                String string = "MQJMS1024";
                String string2 = ConfigEnvironment.getErrorMessage(string);
                IllegalStateException illegalStateException = new IllegalStateException(string2, string);
                throw illegalStateException;
            }
            switch (this.getAcknowledgeMode()) {
                case 1: {
                    if (!Trace.isOn) break;
                    Trace.trace(this, "AUTO_ACKNOWLEDGE Session. forceAck = " + bl);
                    break;
                }
                case 3: {
                    if (!Trace.isOn) break;
                    Trace.trace(this, "DUPS_OK_ACKNOWELDGE Session. forceAck = " + bl);
                    break;
                }
                case 0: {
                    if (Trace.isOn) {
                        Trace.trace(this, "SESSION_TRANSACTED Session. Returning");
                    }
                    return;
                }
                case 2: {
                    if (Trace.isOn) {
                        Trace.trace(this, "CLIENT_ACKNOWLEDGE Session. Acknowledging message");
                    }
                    this._acknowledgeInternal();
                    return;
                }
                default: {
                    if (Trace.isOn) {
                        Trace.trace(this, "Unknown AcknowledgeMode. GIving up and returning");
                    }
                    return;
                }
            }
            if (bl) {
                this._acknowledgeInternal();
            }
            return;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Leaving via Exception");
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "_acknowledge");
            }
        }
    }

    public void _acknowledgeInternal() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "_acknowledge");
            }
            if (this.transacted) {
                String string = "MQJMS1020";
                String string2 = ConfigEnvironment.getErrorMessage(string);
                IllegalStateException illegalStateException = new IllegalStateException(string2, string);
                throw illegalStateException;
            }
            if (!this.callingFromOnMessage() && this.isClosed()) {
                String string = "MQJMS1024";
                String string3 = ConfigEnvironment.getErrorMessage(string);
                IllegalStateException illegalStateException = new IllegalStateException(string3, string);
                throw illegalStateException;
            }
            if (this.qm == null) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS2004");
                throw jMSException;
            }
            try {
                boolean bl = false;
                try {
                    bl = !this.outcomeNotification && this.qm instanceof MQSPIQueueManager && ((MQSPIQueueManager)this.qm).spiSupportsInherited();
                }
                catch (MQException mQException) {
                    bl = false;
                }
                if (bl) {
                    ((MQSPIQueueManager)this.qm).asyncCommit();
                } else {
                    this.qm.commit();
                }
                if (this.acknowledgeMode == 2) {
                    this.setCommitRequired(false);
                }
            }
            catch (MQException mQException) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS2009");
                jMSException.setLinkedException((Exception)mQException);
                throw jMSException;
            }
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "_acknowledge throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception != null) {
                    Trace.trace(this, "linked exception " + exception);
                }
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "_acknowledge");
            }
        }
    }

    final Object getTransactionLock() {
        if (Trace.isOn) {
            Trace.entryexit(this, "getTransactionLock");
        }
        return this.transactionLock;
    }

    final boolean isClosed() {
        boolean bl;
        boolean bl2 = bl = this.state == 2;
        if (Trace.isOn) {
            Trace.entryexit(this, "isClosed", String.valueOf(bl));
        }
        return bl;
    }

    boolean isStarted() {
        boolean bl;
        boolean bl2 = bl = this.state == 1;
        if (Trace.isOn) {
            Trace.entryexit(this, "isStarted", String.valueOf(bl));
        }
        return bl;
    }

    boolean isStopped() {
        boolean bl;
        boolean bl2 = bl = this.state == 0;
        if (Trace.isOn) {
            Trace.entryexit(this, "isStopped", String.valueOf(bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() throws SessionClosedException, JMSException {
        block14: {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "start");
                }
                if (this.state == 2) {
                    String string = ConfigEnvironment.getErrorMessage("MQJMS1024");
                    SessionClosedException sessionClosedException = new SessionClosedException(string);
                    throw sessionClosedException;
                }
                if (this.state == 1) {
                    break block14;
                }
                if (this.state == 0) {
                    this.state = 1;
                    Object object = this.stateChangeSem;
                    synchronized (object) {
                        this.stateChangeSem.notifyAll();
                        break block14;
                    }
                }
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1005", String.valueOf(this.state), "STATE_STARTED");
                throw jMSException;
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                }
                throw jMSException;
            }
            finally {
                if (Trace.isOn) {
                    Trace.exit(this, "start");
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void stop() throws SessionClosedException, JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "stop");
            }
            if (this.state == 2) {
                String string = ConfigEnvironment.getErrorMessage("MQJMS1024");
                SessionClosedException sessionClosedException = new SessionClosedException(string);
                throw sessionClosedException;
            }
            if (this.state == 1) {
                this.state = 0;
                Object object = this.transactionLock;
                // MONITORENTER : object
                // MONITOREXIT : object
                return;
            }
            if (this.state == 0) {
                return;
            }
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1005", String.valueOf(this.state), "STATE_STOPPED");
            throw jMSException;
        }
        catch (JMSException jMSException) {
            if (!Trace.isOn) throw jMSException;
            Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "stop");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void waitForStart() throws SessionClosedException, JMSException {
        try {
            Object object;
            if (Trace.isOn) {
                Trace.entry(this, "waitForStart");
            }
            while (this.state == 0) {
                object = this.stateChangeSem;
                synchronized (object) {
                    try {
                        this.stateChangeSem.wait(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            switch (this.state) {
                case 1: {
                    return;
                }
                case 2: {
                    object = ConfigEnvironment.getErrorMessage("MQJMS1024");
                    SessionClosedException sessionClosedException = new SessionClosedException((String)object);
                    throw sessionClosedException;
                }
                default: {
                    try {
                        String string = ConfigEnvironment.getMessage("MQJMS1006", "state", String.valueOf(this.state));
                        Logger.log(new LogMessage(2, "MQJMS1016", string));
                    }
                    catch (LogException logException) {
                        System.err.println("failed to log error because of " + logException);
                    }
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1016", "unknown value of state " + this.state);
                    throw jMSException;
                }
            }
        }
        catch (JMSException jMSException) {
            if (!Trace.isOn) throw jMSException;
            Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "waitForStart");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long waitForStart(long l) throws SessionClosedException, JMSException {
        try {
            Object object;
            if (Trace.isOn) {
                Trace.entry(this, "waitForStart");
            }
            long l2 = 0L;
            long l3 = System.currentTimeMillis();
            long l4 = l3 + l;
            long l5 = l3;
            while (this.state == 0 && l5 < l4) {
                object = this.stateChangeSem;
                synchronized (object) {
                    try {
                        this.stateChangeSem.wait(l4 - l5);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    l5 = System.currentTimeMillis();
                }
            }
            switch (this.state) {
                case 1: {
                    l2 = Math.max(0L, l4 - l5);
                    break;
                }
                case 2: {
                    object = ConfigEnvironment.getErrorMessage("MQJMS1024");
                    SessionClosedException sessionClosedException = new SessionClosedException((String)object);
                    throw sessionClosedException;
                }
                case 0: {
                    l2 = 0L;
                    break;
                }
                default: {
                    Object object2;
                    try {
                        object2 = ConfigEnvironment.getMessage("MQJMS1006", "state", String.valueOf(this.state));
                        Logger.log(new LogMessage(2, "MQJMS1016", object2));
                    }
                    catch (LogException logException) {
                        System.err.println("failed to log error because of " + logException);
                    }
                    object2 = ConfigEnvironment.newException("MQJMS1016", "unknown value of state " + this.state);
                    throw object2;
                }
            }
            long l6 = l2;
            return l6;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "waitForStart");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetQRs() {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "resetQRs");
            }
            Enumeration enumeration = this.messageConsumers.elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e instanceof MQQueueReceiver) {
                    ((MQQueueReceiver)e).resetBrowse();
                    continue;
                }
                if (!Trace.isOn) continue;
                Trace.trace(this, "Oddness: resetQRs found consumer that wasn't a QR");
            }
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "resetQRs");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeAllChildren() {
        try {
            Object object;
            if (Trace.isOn) {
                Trace.entry(this, "closeAllChildren");
            }
            Vector vector = (Vector)this.messageProducers.clone();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                try {
                    object = (MessageProducer)enumeration.nextElement();
                    object.close();
                }
                catch (JMSException jMSException) {
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                    break;
                }
            }
            object = (Vector)this.messageConsumers.clone();
            enumeration = ((Vector)object).elements();
            while (enumeration.hasMoreElements()) {
                try {
                    MessageConsumer messageConsumer = (MessageConsumer)enumeration.nextElement();
                    messageConsumer.close();
                }
                catch (JMSException jMSException) {
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                    break;
                }
            }
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "closeAllChildren");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addProducer(MessageProducer messageProducer) {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "addProducer");
            }
            this.messageProducers.addElement(messageProducer);
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "addProducer");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeProducer(MessageProducer messageProducer) {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "removeProducer");
            }
            this.messageProducers.removeElement(messageProducer);
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "removeProducer");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addConsumer(MessageConsumer messageConsumer) {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "addConsumer");
            }
            this.messageConsumers.addElement(messageConsumer);
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "addConsumer");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeConsumer(MessageConsumer messageConsumer) {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "removeConsumer");
            }
            this.messageConsumers.removeElement(messageConsumer);
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "removeConsumer");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean usingAsyncMode() {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "usingAsyncMode");
            }
            boolean bl = this.asyncHelper == null ? false : this.asyncHelper.hasReceivers();
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "usingAsyncMode");
            }
        }
    }

    final boolean hasMessageListener() {
        return this.messageListener != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addAsync(MQMessageConsumer mQMessageConsumer) {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "addAsync");
            }
            if (this.asyncHelper == null) {
                if (Trace.isOn) {
                    Trace.trace(this, "creating asyncHelper Thread");
                }
                this.asyncHelper = new SessionAsyncHelper(this.connection, this);
            }
            this.asyncHelper.addReceiver(mQMessageConsumer);
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "addAsync");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAsync(MQMessageConsumer mQMessageConsumer) {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "removeAsync");
            }
            if (this.asyncHelper != null) {
                this.asyncHelper.removeReceiver(mQMessageConsumer);
            }
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "removeAsync");
            }
        }
    }

    boolean getSyncpointAllGets() {
        return this.connection.getSyncpointAllGets();
    }

    final int getFailIfQuiesce() {
        return this.connection.getFailIfQuiesce();
    }

    final boolean getPersistenceFromMD() {
        return this.persistenceFromMD;
    }

    final boolean getPlayNice() {
        return this.playNice;
    }

    void setPlayNice(boolean bl) {
        this.playNice = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean callingFromOnMessage() {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "callingFromOnMessage");
            }
            boolean bl = this.asyncHelper == null ? false : this.asyncHelper.callingFromOnMessage();
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "callingFromOnMessage");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void discQM() {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "discQM");
            }
            if (this.qm != null) {
                try {
                    this.qm.disconnect();
                    this.qm = null;
                }
                catch (MQException mQException) {
                    if (Trace.isOn) {
                        Trace.trace(this, "qm.disc failed with " + mQException);
                    }
                }
            } else if (Trace.isOn) {
                Trace.trace(this, "qm already null");
            }
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "discQM");
            }
        }
    }

    final int getDistTransactionMode() {
        return this.distTransactionMode;
    }

    void setDistTransactionMode(int n) {
        this.distTransactionMode = n;
        if (Trace.isOn) {
            Trace.trace(this, "setDistTransactionMode setting mode to " + n);
        }
    }

    void checkSessionOpen() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "checkSessionOpen");
        }
        if (this.isClosed()) {
            String string = "MQJMS1024";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            IllegalStateException illegalStateException = new IllegalStateException(string2, string);
            if (Trace.isOn) {
                Trace.trace(this, "Session is closed. Throwing IllegalStateException.");
            }
            throw illegalStateException;
        }
        if (Trace.isOn) {
            Trace.exit(this, "checkSessionOpen");
        }
    }

    /*
     * Loose catch block
     */
    void redirectMessage(String string, MQMsg2 mQMsg2, boolean bl) throws JMSException {
        block27: {
            MQQueue mQQueue = null;
            try {
                block26: {
                    if (Trace.isOn) {
                        Trace.entry(this, "redirectMessage");
                        Trace.trace(this, "sending message to '" + string + "'");
                    }
                    if (this.isClosed()) {
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1024");
                        throw jMSException;
                    }
                    if (this.qm == null) {
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS2004");
                        throw jMSException;
                    }
                    MQPutMessageOptions mQPutMessageOptions = new MQPutMessageOptions();
                    if (bl) {
                        mQPutMessageOptions.options |= 2;
                        mQPutMessageOptions.options &= 0xFFFFFFFB;
                    } else {
                        mQPutMessageOptions.options |= 4;
                        mQPutMessageOptions.options &= 0xFFFFFFFD;
                    }
                    this.qm.putMsg2(string, "", mQMsg2, mQPutMessageOptions);
                    Object var8_10 = null;
                    if (!Trace.isOn) break block26;
                    Trace.trace(this, "redirectMessage finally block");
                }
                if (mQQueue == null) break block27;
                try {
                    mQQueue.close();
                }
                catch (MQException mQException) {
                    try {
                        Logger.log(new LogMessage(2, "MQJMS2000"));
                    }
                    catch (LogException logException) {
                        System.err.println("failed to log error because of " + logException);
                    }
                    if (Trace.isOn) {
                        Trace.exception(this, "redirectMessage() failed to close queue", (Throwable)mQException);
                    }
                    break block27;
                }
                {
                    catch (MQException mQException) {
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1022");
                        jMSException.setLinkedException((Exception)mQException);
                        throw jMSException;
                    }
                }
                catch (Throwable throwable) {
                    block29: {
                        Object var8_11 = null;
                        if (Trace.isOn) {
                            Trace.trace(this, "redirectMessage finally block");
                        }
                        if (mQQueue != null) {
                            try {
                                mQQueue.close();
                            }
                            catch (MQException mQException) {
                                try {
                                    Logger.log(new LogMessage(2, "MQJMS2000"));
                                }
                                catch (LogException logException) {
                                    System.err.println("failed to log error because of " + logException);
                                }
                                if (!Trace.isOn) break block29;
                                Trace.exception(this, "redirectMessage() failed to close queue", (Throwable)mQException);
                            }
                        }
                    }
                    throw throwable;
                }
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.trace(this, "throwing exception: " + (Object)((Object)jMSException));
                    Exception exception = jMSException.getLinkedException();
                    if (exception != null) {
                        Trace.trace(this, "linked exception " + exception);
                    }
                }
                throw jMSException;
            }
            finally {
                if (Trace.isOn) {
                    Trace.exit(this, "redirectMessage");
                }
            }
        }
    }

    public MessageReference recreateMessageReference(byte[] byArray) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "recreateMessageReference");
                Trace.trace(this, "flattened MessageReference follows");
                Trace.dataTrace(1, this, byArray);
            }
            MQMessageReference mQMessageReference = new MQMessageReference(this, byArray);
            return mQMessageReference;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Leaving via Exception");
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "recreateMessageReference");
            }
        }
    }

    public Message consume(MessageReference messageReference) throws JMSException {
        Object object;
        int n = 0;
        try {
            Object object2;
            MQGetMessageOptions mQGetMessageOptions;
            MQMessageReference mQMessageReference;
            block45: {
                int n2;
                if (Trace.isOn) {
                    Trace.entry(this, "consume", "mr = \n" + (messageReference instanceof MQMessageReference ? messageReference.toString() : "not an MQMessageReference"));
                }
                if (!(messageReference instanceof MQMessageReference)) {
                    JMSException jMSException = new JMSException("MQJMS1096");
                    if (Trace.isOn) {
                        Trace.trace(this, "MessageReference is not an MQMessageReference, throwing exception");
                        Trace.exception(this, "consume", (Throwable)jMSException);
                    }
                    throw jMSException;
                }
                mQMessageReference = (MQMessageReference)messageReference;
                object = mQMessageReference.getReferenceQueue();
                if (Trace.isOn) {
                    Trace.trace(this, "Got referenceQueueName = '" + (String)object + "'");
                }
                this.messageQueueName = object;
                mQGetMessageOptions = new MQGetMessageOptions(true);
                MQQueueManager mQQueueManager = this.getQM();
                if (Trace.isOn) {
                    Trace.trace(this, "Setting up GMO");
                }
                if ((n2 = mQMessageReference.getVersion()) == 1) {
                    mQGetMessageOptions.matchOptions = 1;
                } else if (n2 == 2) {
                    System.arraycopy(mQMessageReference.getMsgToken(), 0, mQGetMessageOptions.msgToken, 0, 16);
                    mQGetMessageOptions.matchOptions = 32;
                }
                mQGetMessageOptions.options = 8256;
                if (Trace.isOn) {
                    Trace.trace(this, "useSPIP = " + this.useSPIP);
                }
                mQGetMessageOptions.options = this.useSPIP ? (mQGetMessageOptions.options |= 0x1000) : (mQGetMessageOptions.options |= 2);
                try {
                    if (this.cbInputQueue == null || this.messageQueueName != this.lastQueueName) {
                        if (Trace.isOn) {
                            Trace.trace(this, "Queue " + this.messageQueueName + " to be opened");
                        }
                        if (this.cbInputQueue != null) {
                            this.cbInputQueue.close();
                        }
                        this.cbInputQueue = mQQueueManager.accessQueue(this.messageQueueName, 8194);
                        this.lastQueueName = this.messageQueueName;
                        if (Trace.isOn) {
                            Trace.trace(this, "Got access to " + this.cbInputQueue.name);
                        }
                    } else if (Trace.isOn) {
                        Trace.trace(this, "using cached queue for " + this.messageQueueName);
                    }
                }
                catch (MQException mQException) {
                    if (mQException.completionCode != 2) break block45;
                    if (Trace.isOn) {
                        Trace.exception(this, "consume", (Throwable)mQException);
                    }
                    throw mQException;
                }
            }
            JMSMessage jMSMessage = null;
            if (this.cbInputQueue != null) {
                if (mQMessageReference.getDataQuantity() == 2) {
                    jMSMessage = mQMessageReference.getJMSMessage();
                    object2 = mQMessageReference.getMQJMSMessage();
                    if (object2 == null) {
                        object2 = new MQJMSMessage();
                        ((MQMsg2)object2).setMessageId(mQMessageReference.getMessageId());
                        ((MQMsg2)object2).setCorrelationId(mQMessageReference.getCorrelId());
                    }
                    if ((n = this.cbInputQueue.getMsg2NoExc((MQMsg2)object2, mQGetMessageOptions, 0)) == 2079) {
                        n = 0;
                    }
                    if (n != 0) {
                        jMSMessage = null;
                    }
                } else {
                    object2 = mQMessageReference.getMQJMSMessage();
                    if (object2 == null) {
                        object2 = new MQJMSMessage();
                        ((MQMsg2)object2).setMessageId(mQMessageReference.getMessageId());
                        ((MQMsg2)object2).setCorrelationId(mQMessageReference.getCorrelId());
                    }
                    mQGetMessageOptions.options &= 0xFFFFFFBF;
                    n = this.cbInputQueue.getMsg2NoExc((MQMsg2)object2, mQGetMessageOptions);
                    if (n == 0) {
                        jMSMessage = ((MQJMSMessage)object2).createJMSMessage(this);
                    }
                }
                if (n == 2033) {
                    if (Trace.isOn) {
                        Trace.trace(this, "NO_MSG_AVAILABLE - message removed from queue");
                    }
                    object2 = null;
                    return object2;
                }
                if (n != 0) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Got MQRC " + n);
                    }
                    throw new MQException(2, n, this);
                }
            } else {
                Message message = null;
                return message;
            }
            if (!this.getTransacted()) {
                jMSMessage._setSession(this);
            }
            jMSMessage.setGotByConsume(true);
            object2 = jMSMessage;
            return object2;
        }
        catch (MQException mQException) {
            if (Trace.isOn) {
                Trace.exception(this, "caught MQException", (Throwable)mQException);
            }
            object = ConfigEnvironment.newException("MQJMS2002");
            object.setLinkedException((Exception)mQException);
            throw object;
        }
        catch (IOException iOException) {
            if (Trace.isOn) {
                Trace.exception(this, "caught IOException - badly formatted message", (Throwable)iOException);
            }
            object = ConfigEnvironment.newException("MQJMS0006");
            object.setLinkedException((Exception)iOException);
            throw object;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Leaving via Exception");
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "consume");
            }
        }
    }

    public Message consume(byte[] byArray) throws JMSException {
        try {
            Message message;
            if (Trace.isOn) {
                Trace.entry(this, "consume(byte[])");
                Trace.trace(this, "recreating MessageReference");
            }
            MessageReference messageReference = this.recreateMessageReference(byArray);
            if (Trace.isOn) {
                Trace.trace(this, "Recreated MessageReference. Trying to consume message");
            }
            Message message2 = message = this.consume(messageReference);
            return message2;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Leaving via Exception");
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "consume(byte[])");
            }
        }
    }

    public MessageReference recreateMessageReference(byte[] byArray, MQSession mQSession) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "recreateMessageReference");
                Trace.trace(this, "flattened MessageReference follows");
                Trace.dataTrace(1, this, byArray);
            }
            MQMessageReference mQMessageReference = new MQMessageReference(mQSession, byArray);
            return mQMessageReference;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Leaving via Exception");
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "recreateMessageReference");
            }
        }
    }

    MQQueue getQueueForBrowse(com.ibm.mq.jms.MQQueue mQQueue) throws JMSException {
        return this.getServicesMgr().getQueueForBrowse(mQQueue, this);
    }

    MQQueue getOutputQueue(com.ibm.mq.jms.MQQueue mQQueue) throws JMSException {
        return this.getServicesMgr().getOutputQueue(mQQueue, this);
    }

    protected JMSException getQueueOpenException(MQException mQException) throws JMSException {
        return this.getServicesMgr().getQueueOpenException(mQException);
    }

    void checkQueueAccess(com.ibm.mq.jms.MQQueue mQQueue) throws JMSException {
        this.getServicesMgr().checkQueueAccess(mQQueue, this);
    }

    final String getDLQName() throws JMSException {
        if (Trace.isOn) {
            Trace.entryexit(this, "getDLQName");
        }
        return this.deadLetterQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSender(MQMessageProducer mQMessageProducer) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "removeSender");
            }
            this.removeProducer(mQMessageProducer);
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "removeSender");
            }
        }
    }

    final MQQueueManager getQM() {
        return this.qm;
    }

    BrokerConnectionInfo getBrk() throws JMSException {
        return this.brk;
    }

    void sendCommand(String string, int n, String string2, byte[] byArray) throws JMSException {
        this.getServicesMgr().sendCommand(string, n, string2, byArray, this.wait_for_reply, false, this);
    }

    void sendCommand(String string, int n, String string2, byte[] byArray, boolean bl) throws JMSException {
        this.getServicesMgr().sendCommand(string, n, string2, byArray, bl, false, this);
    }

    String getConnectionID() throws JMSException {
        try {
            return this.connection.getConnectionID();
        }
        catch (JMSException jMSException) {
            throw new RuntimeException("MQJMS1016");
        }
    }

    int getConnectionBrokerVersion() throws JMSException {
        try {
            return this.connection.getBrkVersion();
        }
        catch (JMSException jMSException) {
            throw new RuntimeException("MQJMS1016");
        }
    }

    int getConnectionMsgSelection() throws JMSException {
        try {
            return this.connection.getMsgSelection();
        }
        catch (JMSException jMSException) {
            throw new RuntimeException("MQJMS1016");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removePublisher(MQMessageProducer mQMessageProducer) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "removePublisher");
            }
            this.removeProducer(mQMessageProducer);
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "removePublisher");
            }
        }
    }

    MQQueue getResponseQueue() throws JMSException {
        return this.getServicesMgr().getResponseQueue(this);
    }

    boolean getSparseSubscriptions() throws JMSException {
        if (this.connection != null) {
            return this.connection.getSparseSubscriptions();
        }
        if (Trace.isOn) {
            Trace.trace(this, "getSparseSubscriptions, connection null, returning false");
        }
        return false;
    }

    public int getReceiveIsolation() throws JMSException {
        if (Trace.isOn) {
            Trace.trace(this, "receiveIsolation = " + this.receiveIsolation);
        }
        return this.receiveIsolation;
    }

    public void setReceiveIsolation(int n) throws JMSException {
        if (Trace.isOn) {
            Trace.trace(this, "attempting to set receiveIsolation = " + n);
        }
        switch (n) {
            case 0: 
            case 1: {
                this.receiveIsolation = n;
                break;
            }
            default: {
                if (Trace.isOn) {
                    Trace.trace(this, "invalid parameter specified. Resetting to default");
                }
                this.receiveIsolation = 0;
            }
        }
    }

    public boolean getOutcomeNotification() throws JMSException {
        if (Trace.isOn) {
            Trace.trace(this, "outcomeNotification = " + this.outcomeNotification);
        }
        return this.outcomeNotification;
    }

    public void setOutcomeNotification(boolean bl) throws JMSException {
        if (Trace.isOn) {
            Trace.trace(this, "setting outcomeNotification = " + bl);
        }
        this.outcomeNotification = bl;
    }

    public int getProcessDuration() throws JMSException {
        if (Trace.isOn) {
            Trace.trace(this, "processDuration = " + this.processDuration);
        }
        return this.processDuration;
    }

    public void setProcessDuration(int n) throws JMSException {
        if (Trace.isOn) {
            Trace.trace(this, "attempting to set processDuration = " + n);
        }
        switch (n) {
            case 0: 
            case 1: {
                this.processDuration = n;
                break;
            }
            default: {
                if (Trace.isOn) {
                    Trace.trace(this, "Invalid parameter specified. resetting to default");
                }
                this.processDuration = 0;
            }
        }
    }

    public boolean getOptimisticPublication() throws JMSException {
        if (Trace.isOn) {
            Trace.trace(this, "optimisticPublication = " + this.optimisticPublication);
        }
        return this.optimisticPublication;
    }

    public void setOptimisticPublication(boolean bl) throws JMSException {
        if (Trace.isOn) {
            Trace.trace(this, "setting optimisticPublication = " + bl);
        }
        this.optimisticPublication = bl;
    }

    synchronized void setCommitRequired(boolean bl) {
        if (Trace.isOn) {
            Trace.trace(this, "setting commitRequired to " + bl);
        }
        this.commitRequired = bl;
    }

    final synchronized boolean getCommitRequired() {
        if (Trace.isOn) {
            Trace.trace(this, "commitRequired currently set to " + this.commitRequired);
        }
        return this.commitRequired;
    }

    void responseRequested(long l, byte[] byArray) throws JMSException {
        if (Trace.isOn) {
            Trace.trace(this, "responseRequested");
        }
        if (!this.transacted) {
            this.responseRequested = true;
            this.responsePutTime = l;
        } else {
            this.responseOnCommit = true;
        }
        System.arraycopy(byArray, 0, this.responseCorrelId, 0, byArray.length);
        for (int i = byArray.length; i < this.responseCorrelId.length; ++i) {
            this.responseCorrelId[i] = 0;
        }
        if (Trace.isOn) {
            Trace.trace(this, "setting responseCorrelId to " + this.responseCorrelId.toString());
        }
        this.publishCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commitQ() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "commitQ");
            }
            if (this.isClosed()) {
                String string = "MQJMS1024";
                String string2 = ConfigEnvironment.getErrorMessage(string);
                IllegalStateException illegalStateException = new IllegalStateException(string2, string);
                throw illegalStateException;
            }
            if (!this.transacted) {
                String string = "MQJMS1019";
                String string3 = ConfigEnvironment.getErrorMessage(string);
                IllegalStateException illegalStateException = new IllegalStateException(string3, string);
                throw illegalStateException;
            }
            if (this.qm == null) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS2004");
                throw jMSException;
            }
            try {
                Object object = this.getTransactionLock();
                synchronized (object) {
                    this.qm.commit();
                    this.setCommitRequired(false);
                }
            }
            catch (MQException mQException) {
                JMSException jMSException;
                int n = mQException.completionCode;
                int n2 = mQException.reasonCode;
                if (n == 1 && n2 == 2003) {
                    String string = "MQJMS0011";
                    String string4 = ConfigEnvironment.getErrorMessage(string);
                    jMSException = new TransactionRolledBackException(string4, string);
                } else {
                    jMSException = ConfigEnvironment.newException("MQJMS2009");
                }
                jMSException.setLinkedException((Exception)mQException);
                throw jMSException;
            }
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "commitQ");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rollbackQ() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "rollbackQ");
            }
            if (this.isClosed()) {
                String string = "MQJMS1024";
                String string2 = ConfigEnvironment.getErrorMessage(string);
                IllegalStateException illegalStateException = new IllegalStateException(string2, string);
                throw illegalStateException;
            }
            if (!this.transacted) {
                String string = "MQJMS1019";
                String string3 = ConfigEnvironment.getErrorMessage(string);
                IllegalStateException illegalStateException = new IllegalStateException(string3, string);
                throw illegalStateException;
            }
            if (this.qm == null) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS2004");
                throw jMSException;
            }
            try {
                Object object = this.getTransactionLock();
                synchronized (object) {
                    this.qm.backout();
                }
            }
            catch (MQException mQException) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1023");
                jMSException.setLinkedException((Exception)mQException);
                throw jMSException;
            }
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "rollbackQ");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recoverQ() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "recoverQ");
            }
            if (this.isClosed()) {
                String string = "MQJMS1024";
                String string2 = ConfigEnvironment.getErrorMessage(string);
                IllegalStateException illegalStateException = new IllegalStateException(string2, string);
                throw illegalStateException;
            }
            if (this.transacted) {
                String string = "MQJMS1020";
                String string3 = ConfigEnvironment.getErrorMessage(string);
                IllegalStateException illegalStateException = new IllegalStateException(string3, string);
                throw illegalStateException;
            }
            if (this.qm == null) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS2004");
                throw jMSException;
            }
            try {
                this.setPlayNice(true);
                Object object = this.getTransactionLock();
                synchronized (object) {
                    this.setPlayNice(false);
                    if (this.qm.isConnected()) {
                        try {
                            this.qm.backout();
                        }
                        catch (NullPointerException nullPointerException) {
                            JMSException jMSException = ConfigEnvironment.newException("MQJMS1021");
                            jMSException.setLinkedException((Exception)nullPointerException);
                            throw jMSException;
                        }
                        this.resetQRs();
                    } else if (Trace.isOn) {
                        Trace.trace(this, "qm not connected - race condition?");
                    }
                }
            }
            catch (MQException mQException) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1021");
                jMSException.setLinkedException((Exception)mQException);
                throw jMSException;
            }
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception != null) {
                    Trace.trace(this, "linked exception " + exception);
                }
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "recoverQ");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commitT() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "commitT");
            }
            if (this.isClosed()) {
                String string = "MQJMS1024";
                String string2 = ConfigEnvironment.getErrorMessage(string);
                IllegalStateException illegalStateException = new IllegalStateException(string2, string);
                throw illegalStateException;
            }
            if (!this.transacted) {
                String string = "MQJMS1019";
                String string3 = ConfigEnvironment.getErrorMessage(string);
                IllegalStateException illegalStateException = new IllegalStateException(string3, string);
                throw illegalStateException;
            }
            if (this.qm == null) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS2004");
                throw jMSException;
            }
            try {
                Object object = this.getTransactionLock();
                synchronized (object) {
                    boolean bl = false;
                    boolean bl2 = bl = !this.outcomeNotification && this.qm instanceof MQSPIQueueManager && this.supportsInherited();
                    if (bl) {
                        ((MQSPIQueueManager)this.qm).asyncCommit();
                    } else {
                        this.qm.commit();
                    }
                    this.setCommitRequired(false);
                    if (this.responseOnCommit) {
                        this.responseOnCommit = false;
                        this.responseRequested = true;
                        this.responsePutTime = System.currentTimeMillis();
                        if (this.getServicesMgr().checkForResponse(this)) {
                            try {
                                MQMsg2 mQMsg2 = new MQMsg2();
                                this.getServicesMgr().getBrokerResponse(this, mQMsg2, false);
                            }
                            catch (JMSException jMSException) {
                                if (Trace.isOn) {
                                    Trace.trace(this, "caught " + (Object)((Object)jMSException));
                                    Exception exception = jMSException.getLinkedException();
                                    if (exception != null) {
                                        Trace.trace(this, "linked exception " + exception);
                                    }
                                }
                                throw jMSException;
                            }
                        }
                    }
                }
            }
            catch (MQException mQException) {
                int n = mQException.completionCode;
                int n2 = mQException.reasonCode;
                JMSException jMSException = n == 1 && n2 == 2003 ? new TransactionRolledBackException(ConfigEnvironment.getMessage("MQJMS0011")) : ConfigEnvironment.newException("MQJMS2009");
                if (this.responseOnCommit) {
                    this.responseOnCommit = false;
                }
                jMSException.setLinkedException((Exception)mQException);
                throw jMSException;
            }
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception != null) {
                    Trace.trace(this, "linked exception " + exception);
                }
            }
            throw jMSException;
        }
        finally {
            Trace.exit(this, "commitT");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rollbackT() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "rollbackT");
            }
            if (this.isClosed()) {
                String string = "MQJMS1024";
                String string2 = ConfigEnvironment.getErrorMessage(string);
                IllegalStateException illegalStateException = new IllegalStateException(string2, string);
                throw illegalStateException;
            }
            if (!this.transacted) {
                String string = "MQJMS1019";
                String string3 = ConfigEnvironment.getErrorMessage(string);
                IllegalStateException illegalStateException = new IllegalStateException(string3, string);
                throw illegalStateException;
            }
            if (this.qm == null) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS2004");
                throw jMSException;
            }
            try {
                Object object = this.getTransactionLock();
                synchronized (object) {
                    this.qm.backout();
                    this.setCommitRequired(false);
                    if (this.responseOnCommit) {
                        this.responseOnCommit = false;
                    }
                }
            }
            catch (MQException mQException) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1023");
                jMSException.setLinkedException((Exception)mQException);
                throw jMSException;
            }
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception != null) {
                    Trace.trace(this, "linked exception " + exception);
                }
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "rollbackT");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recoverT() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "recoverT");
            }
            if (this.isClosed()) {
                String string = "MQJMS1024";
                String string2 = ConfigEnvironment.getErrorMessage(string);
                IllegalStateException illegalStateException = new IllegalStateException(string2, string);
                throw illegalStateException;
            }
            if (this.transacted) {
                String string = "MQJMS1024";
                String string3 = ConfigEnvironment.getErrorMessage(string);
                IllegalStateException illegalStateException = new IllegalStateException(string3, string);
                throw illegalStateException;
            }
            if (this.qm == null) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS2004");
                throw jMSException;
            }
            try {
                this.setPlayNice(true);
                Object object = this.getTransactionLock();
                synchronized (object) {
                    this.setPlayNice(false);
                    if (this.qm.isConnected()) {
                        try {
                            this.qm.backout();
                            this.setCommitRequired(false);
                        }
                        catch (NullPointerException nullPointerException) {
                            JMSException jMSException = ConfigEnvironment.newException("MQJMS1021");
                            jMSException.setLinkedException((Exception)nullPointerException);
                            throw jMSException;
                        }
                    } else if (Trace.isOn) {
                        Trace.trace(this, "qm not connected - race condition?");
                    }
                }
            }
            catch (MQException mQException) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1021");
                jMSException.setLinkedException((Exception)mQException);
                throw jMSException;
            }
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "recover throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception != null) {
                    Trace.trace(this, "linked exception " + exception);
                }
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "recoverT");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeT() {
        block15: {
            try {
                block16: {
                    Exception exception;
                    block14: {
                        if (Trace.isOn) {
                            Trace.entry(this, "closeT");
                        }
                        if (this.isStarted() && this.usingAsyncMode()) {
                            try {
                                this.stop();
                            }
                            catch (JMSException jMSException) {
                                if (!Trace.isOn) break block14;
                                Trace.trace(this, "implicit stop failed with " + (Object)((Object)jMSException));
                                exception = jMSException.getLinkedException();
                                if (exception == null) break block14;
                                Trace.trace(this, "linked exception " + exception);
                            }
                        }
                    }
                    if (this.replyQ == null) break block15;
                    if (this.responseRequested) {
                        try {
                            MQMsg2 mQMsg2 = new MQMsg2();
                            this.getServicesMgr().getBrokerResponse(this, mQMsg2, false);
                        }
                        catch (JMSException jMSException) {
                            if (!Trace.isOn) break block16;
                            Trace.trace(this, "caught " + (Object)((Object)jMSException));
                            exception = jMSException.getLinkedException();
                            if (exception == null) break block16;
                            Trace.trace(this, "linked exception " + exception);
                        }
                    }
                }
                try {
                    this.replyQ.close();
                    this.replyQ = null;
                }
                catch (MQException mQException) {
                    if (Trace.isOn) {
                        Trace.trace(this, "caught " + mQException);
                    }
                }
            }
            finally {
                if (Trace.isOn) {
                    Trace.exit(this, "closeT");
                }
            }
        }
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return this.createBrowser(queue, null);
    }

    public QueueBrowser createBrowser(Queue queue, String string) throws JMSException {
        try {
            MQQueueBrowser mQQueueBrowser;
            if (Trace.isOn) {
                Trace.entry(this, "CreateBrowser");
            }
            if (this.isClosed()) {
                String string2 = "MQJMS1024";
                String string3 = ConfigEnvironment.getErrorMessage(string2);
                IllegalStateException illegalStateException = new IllegalStateException(string3, string2);
                throw illegalStateException;
            }
            if (queue == null || !(queue instanceof com.ibm.mq.jms.MQQueue)) {
                String string4 = "MQJMS0003";
                String string5 = ConfigEnvironment.getErrorMessage(string4);
                InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string5, string4);
                throw invalidDestinationException;
            }
            this.addQueueServices();
            com.ibm.mq.jms.MQQueue mQQueue = (com.ibm.mq.jms.MQQueue)queue;
            String string6 = mQQueue.getBaseQueueManagerName();
            this.getServicesMgr().checkQueueAccess(mQQueue, this);
            if (!(string6 == null || string6.equals("") || string6.equals(this.resolvedQmName) || string6.equals(this.resolvedQSGName))) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1017");
                throw jMSException;
            }
            String string7 = mQQueue.getBaseQueueName();
            if (string7 == null) {
                String string8 = "MQJMS0003";
                String string9 = ConfigEnvironment.getErrorMessage(string8);
                InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string9, string8);
                throw invalidDestinationException;
            }
            MQQueueBrowser mQQueueBrowser2 = mQQueueBrowser = new MQQueueBrowser(queue, string, this);
            return mQQueueBrowser2;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createQueueBrowser");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Queue createQueue(String string) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createQueue");
            }
            this.checkSessionOpen();
            String string2 = null;
            if (string != null) {
                string2 = string.trim();
            }
            com.ibm.mq.jms.MQQueue mQQueue = new com.ibm.mq.jms.MQQueue(string2);
            mQQueue.setFailIfQuiesce(this.connection.getFailIfQuiesce());
            com.ibm.mq.jms.MQQueue mQQueue2 = mQQueue;
            return mQQueue2;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createQueue");
            }
        }
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createTemporaryQueue");
            }
            if (this.isClosed()) {
                String string = "MQJMS1024";
                String string2 = ConfigEnvironment.getErrorMessage(string);
                IllegalStateException illegalStateException = new IllegalStateException(string2, string);
                throw illegalStateException;
            }
            if (this.connection == null) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1018");
                throw jMSException;
            }
            MQTemporaryQueue mQTemporaryQueue = this.connection.createTemporaryQueue();
            return mQTemporaryQueue;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createTemporaryQueue");
            }
        }
    }

    public void setBrokerTimeout(int n) throws JMSException {
        if (Trace.isOn) {
            Trace.trace(this, "setBrokerTimeout to " + n);
        }
        this.brokerTimeout = n;
        this.wait_for_reply = this.brokerTimeout > 0;
    }

    public int getBrokerTimeout() throws JMSException {
        return this.brokerTimeout;
    }

    byte[] getSessionName() throws JMSException {
        return this.sessionName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Topic createTopic(String string) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createTopic");
            }
            this.checkSessionOpen();
            this.addPubSubServices();
            String string2 = null;
            if (string != null) {
                string2 = string.trim();
            }
            MQTopic mQTopic = new MQTopic(string2);
            mQTopic.setBrokerVersion(this.connection.getBrkVersion());
            mQTopic.defaultBrkVer = this.connection.getBrkVersion();
            mQTopic.setFailIfQuiesce(this.connection.getFailIfQuiesce());
            MQTopic mQTopic2 = mQTopic;
            return mQTopic2;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createTopic");
            }
        }
    }

    private MQMessageConsumer createTConsumer(Topic topic, String string, boolean bl) throws JMSException {
        Object var4_4 = null;
        Object var5_5 = null;
        MQMessageConsumer mQMessageConsumer = null;
        Object var7_7 = null;
        MQSubscription mQSubscription = null;
        boolean bl2 = true;
        boolean bl3 = this.wait_for_reply;
        boolean bl4 = false;
        try {
            Object object;
            Trace.checkForTurnTracingOn();
            if (Trace.isOn) {
                Trace.entry(this, "createTConsumer(t,s,n)");
            }
            if (this.isClosed()) {
                String string2 = "MQJMS1024";
                String string3 = ConfigEnvironment.getErrorMessage(string2);
                IllegalStateException illegalStateException = new IllegalStateException(string3, string2);
                throw illegalStateException;
            }
            if (this.qm == null) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS2004");
                throw jMSException;
            }
            if (!(topic instanceof MQTopic)) {
                String string4 = "MQJMS0003";
                String string5 = ConfigEnvironment.getErrorMessage(string4);
                InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string5, string4);
                throw invalidDestinationException;
            }
            this.addPubSubServices();
            MQTopic mQTopic = (MQTopic)topic;
            if (mQTopic.containsAnyWildcard() && mQTopic.getBrokerVersion() != this.connection.getBrkVersion()) {
                if (Trace.isOn) {
                    Trace.trace(this, "Invalid wildcard - InvalidDestinationException");
                    Trace.exit(this, "createSubscriber");
                }
                String string6 = "MQJMS0003";
                String string7 = ConfigEnvironment.getErrorMessage(string6);
                InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string7, string6);
                throw invalidDestinationException;
            }
            if (topic instanceof MQTemporaryTopic) {
                object = (MQTemporaryTopic)topic;
                if (object.isDeleted()) {
                    String string8 = "MQJMS3019";
                    String string9 = ConfigEnvironment.getErrorMessage(string8);
                    InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string9, string8);
                    throw invalidDestinationException;
                }
                if (!this.connection.getConnectionID().equals(object.getConnID())) {
                    String string10 = "MQJMS3020";
                    String string11 = ConfigEnvironment.getErrorMessage(string10);
                    InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string11, string10);
                    throw invalidDestinationException;
                }
            }
            if (this.nondur_subscribeQ.trim().equals("")) {
                this.nondur_subscribeQ = "SYSTEM.JMS.ND.*";
            } else if (!this.nondur_subscribeQ.startsWith("SYSTEM.JMS.ND.")) {
                object = ConfigEnvironment.newException("MQJMS3021", this.nondur_subscribeQ);
                throw object;
            }
            if (this.nondur_subscribeQ.endsWith("*")) {
                bl2 = false;
                if (Trace.isOn) {
                    Trace.trace(this, "Using multi-queue approach.");
                }
            } else {
                bl2 = true;
            }
            if (Trace.isOn) {
                Trace.trace(this, "Prefix: SYSTEM.JMS.ND.");
                Trace.trace(this, "QName:  " + this.nondur_subscribeQ);
            }
            mQSubscription = this.connection.getSubscriptionEngine().openSubscription(this, mQTopic, string, bl, bl2, this.nondur_subscribeQ);
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.exit(this, "createTConsumer(t,s,n)");
            }
            throw jMSException;
        }
        try {
            mQMessageConsumer = new MQMessageConsumer((MQTopic)topic, this, mQSubscription, this.transacted, this.acknowledgeMode);
        }
        catch (JMSException jMSException) {
            block31: {
                if (Trace.isOn) {
                    Trace.trace(this, "Caught JMSException " + (Object)((Object)jMSException));
                }
                if (mQSubscription != null) {
                    try {
                        mQSubscription.close();
                    }
                    catch (JMSException jMSException2) {
                        if (!Trace.isOn) break block31;
                        Trace.trace(this, "Warning: could not close subcription - " + (Object)((Object)jMSException2));
                        Trace.trace(this, "The subscription may remain active");
                    }
                }
            }
            if (Trace.isOn) {
                Trace.trace(this, "Passing on JMSException " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createTConsumer(t,s,n)");
            }
        }
        return mQMessageConsumer;
    }

    protected MQTopicSubscriber createTSubscriber(Topic topic, String string, boolean bl) throws JMSException {
        Object var4_4 = null;
        Object var5_5 = null;
        MQTopicSubscriber mQTopicSubscriber = null;
        Object var7_7 = null;
        MQSubscription mQSubscription = null;
        boolean bl2 = true;
        boolean bl3 = this.wait_for_reply;
        boolean bl4 = false;
        try {
            Object object;
            Trace.checkForTurnTracingOn();
            if (Trace.isOn) {
                Trace.entry(this, "createTSubscriber(t,s,n)");
            }
            if (this.isClosed()) {
                String string2 = "MQJMS1024";
                String string3 = ConfigEnvironment.getErrorMessage(string2);
                IllegalStateException illegalStateException = new IllegalStateException(string3, string2);
                throw illegalStateException;
            }
            if (this.qm == null) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS2004");
                throw jMSException;
            }
            if (!(topic instanceof MQTopic)) {
                String string4 = "MQJMS0003";
                String string5 = ConfigEnvironment.getErrorMessage(string4);
                InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string5, string4);
                throw invalidDestinationException;
            }
            this.addPubSubServices();
            MQTopic mQTopic = (MQTopic)topic;
            if (mQTopic.containsAnyWildcard() && mQTopic.getBrokerVersion() != this.connection.getBrkVersion()) {
                if (Trace.isOn) {
                    Trace.trace(this, "Invalid wildcard - InvalidDestinationException");
                    Trace.exit(this, "createQSubscriber");
                }
                String string6 = "MQJMS0003";
                String string7 = ConfigEnvironment.getErrorMessage(string6);
                InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string7, string6);
                throw invalidDestinationException;
            }
            if (topic instanceof MQTemporaryTopic) {
                object = (MQTemporaryTopic)topic;
                if (object.isDeleted()) {
                    String string8 = "MQJMS3019";
                    String string9 = ConfigEnvironment.getErrorMessage(string8);
                    InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string9, string8);
                    throw invalidDestinationException;
                }
                if (!this.connection.getConnectionID().equals(object.getConnID())) {
                    String string10 = "MQJMS3020";
                    String string11 = ConfigEnvironment.getErrorMessage(string10);
                    InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string11, string10);
                    throw invalidDestinationException;
                }
            }
            if (this.nondur_subscribeQ.trim().equals("")) {
                this.nondur_subscribeQ = "SYSTEM.JMS.ND.*";
            } else if (!this.nondur_subscribeQ.startsWith("SYSTEM.JMS.ND.")) {
                object = ConfigEnvironment.newException("MQJMS3021", this.nondur_subscribeQ);
                throw object;
            }
            if (this.nondur_subscribeQ.endsWith("*")) {
                bl2 = false;
                if (Trace.isOn) {
                    Trace.trace(this, "Using multi-queue approach.");
                }
            } else {
                bl2 = true;
            }
            if (Trace.isOn) {
                Trace.trace(this, "Prefix: SYSTEM.JMS.ND.");
                Trace.trace(this, "QName:  " + this.nondur_subscribeQ);
            }
            mQSubscription = this.connection.getSubscriptionEngine().openSubscription(this, mQTopic, string, bl, bl2, this.nondur_subscribeQ);
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.exit(this, "createTSubscriber(t,s,n)");
            }
            throw jMSException;
        }
        try {
            mQTopicSubscriber = new MQTopicSubscriber((MQTopic)topic, this, mQSubscription, this.transacted, this.acknowledgeMode);
        }
        catch (JMSException jMSException) {
            block31: {
                if (Trace.isOn) {
                    Trace.trace(this, "Caught JMSException " + (Object)((Object)jMSException));
                }
                if (mQSubscription != null) {
                    try {
                        mQSubscription.close();
                    }
                    catch (JMSException jMSException2) {
                        if (!Trace.isOn) break block31;
                        Trace.trace(this, "Warning: could not close subcription - " + (Object)((Object)jMSException2));
                        Trace.trace(this, "The subscription may remain active");
                    }
                }
            }
            if (Trace.isOn) {
                Trace.trace(this, "Passing on JMSException " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createTSubscriber(t,s,n)");
            }
        }
        return mQTopicSubscriber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopicSubscriber createDurableSubscriber(Topic topic, String string) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "createDurableSubscriber");
        }
        try {
            TopicSubscriber topicSubscriber = this.createDurableSubscriber(topic, string, null, false);
            return topicSubscriber;
        }
        finally {
            if (Trace.isOn) {
                Trace.entry(this, "createDurableSubscriber");
            }
        }
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String string, String string2, boolean bl) throws JMSException {
        MQSubscription mQSubscription = null;
        MQTopicSubscriber mQTopicSubscriber = null;
        String string3 = null;
        boolean bl2 = true;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createDurableSubscriber(t,n,s,n)");
            }
            this.addPubSubServices();
            if (this.isClosed()) {
                String string4 = "MQJMS1024";
                String string5 = ConfigEnvironment.getErrorMessage(string4);
                IllegalStateException illegalStateException = new IllegalStateException(string5, string4);
                throw illegalStateException;
            }
            if (this.qm == null) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS2004");
                throw jMSException;
            }
            if (!(topic instanceof MQTopic)) {
                String string6 = "MQJMS0003";
                String string7 = ConfigEnvironment.getErrorMessage(string6);
                InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string7, string6);
                throw invalidDestinationException;
            }
            if (string == null || string.trim().equals("")) {
                String string8 = "MQJMS3039";
                String string9 = ConfigEnvironment.getErrorMessage(string8);
                InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string9, string8);
                throw invalidDestinationException;
            }
            MQTopic mQTopic = (MQTopic)topic;
            if (mQTopic.containsAnyWildcard() && mQTopic.getBrokerVersion() != this.connection.getBrkVersion()) {
                if (Trace.isOn) {
                    Trace.trace(this, "Invalid wildcard - InvalidDestinationException");
                    Trace.exit(this, "createSubscriber");
                }
                String string10 = "MQJMS0003";
                String string11 = ConfigEnvironment.getErrorMessage(string10);
                InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string11, string10);
                throw invalidDestinationException;
            }
            if (topic instanceof MQTemporaryTopic) {
                String string12 = "MQJMS0003";
                String string13 = ConfigEnvironment.getErrorMessage(string12);
                InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string13, string12);
                throw invalidDestinationException;
            }
            string3 = ((MQTopic)topic).getBrokerDurSubQueue();
            if (string3.trim().equals("")) {
                string3 = "SYSTEM.JMS.D.*";
            } else if (!string3.startsWith("SYSTEM.JMS.D.")) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS3021", string3);
                throw jMSException;
            }
            if (string3.endsWith("*")) {
                bl2 = false;
            }
            if (string2 != null && !string2.equals("")) {
                try {
                    MQMessageSelector mQMessageSelector = new MQMessageSelector();
                    mQMessageSelector.setSelector(string2);
                }
                catch (SyntaxException syntaxException) {
                    String string14 = "MQJMS0004";
                    String string15 = ConfigEnvironment.getErrorMessage(string14);
                    InvalidSelectorException invalidSelectorException = new InvalidSelectorException(string15, string14);
                    invalidSelectorException.setLinkedException((Exception)syntaxException);
                    throw invalidSelectorException;
                }
            }
            if (Trace.isOn) {
                Trace.trace(this, "Topic name = " + ((MQTopic)topic).getBaseTopicName());
                Trace.trace(this, "Sub Q name = " + string3);
                Trace.trace(this, "Name       = " + string);
                Trace.trace(this, "Selector   = " + string2);
                Trace.trace(this, "noLocal    = " + bl);
            }
            try {
                mQSubscription = this.connection.getSubscriptionEngine().openDurableSubscription(this, mQTopic, string2, bl, bl2, string3, string);
                mQTopicSubscriber = new MQTopicSubscriber(mQTopic, this, mQSubscription, this.transacted, this.acknowledgeMode);
                this.addConsumer(mQTopicSubscriber);
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                    Exception exception = jMSException.getLinkedException();
                    if (exception != null) {
                        Trace.trace(this, "linked exception " + exception);
                    }
                }
                throw jMSException;
            }
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception != null) {
                    Trace.trace(this, "linked exception " + exception);
                }
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createDurableSubscriber(t,n,s,n)");
            }
        }
        return mQTopicSubscriber;
    }

    private MessageProducer createTProducer(Topic topic) throws JMSException {
        MQMessageProducer mQMessageProducer;
        int n = 16;
        MQQueue mQQueue = null;
        Object object = null;
        try {
            String string;
            Object object2;
            if (Trace.isOn) {
                Trace.entry(this, "createTProducer");
            }
            if (this.isClosed()) {
                String string2 = "MQJMS1024";
                String string3 = ConfigEnvironment.getErrorMessage(string2);
                throw new IllegalStateException(string3, string2);
            }
            this.addPubSubServices();
            object = this.connection.getBrkPubQueue();
            if (topic != null && topic instanceof MQTopic && (object2 = ((MQTopic)topic).getBrokerPubQueue()) != null && !((String)object2).equals("")) {
                object = object2;
            }
            if (topic != null && topic instanceof MQTopic && ((MQTopic)topic).getFailIfQuiesce() == 1) {
                n |= 0x2000;
            }
            if (this.qm == null) {
                object2 = ConfigEnvironment.newException("MQJMS2004");
                throw object2;
            }
            if (topic instanceof MQTemporaryTopic && ((MQTemporaryTopic)(object2 = (MQTemporaryTopic)topic)).isDeleted()) {
                JMSException jMSException = new JMSException("TemporaryTopic already deleted");
                throw jMSException;
            }
            object2 = this.brk.qmName;
            if (topic != null && topic instanceof MQTopic && (string = ((MQTopic)topic).getBrokerPubQueueManager()) != null && !string.equals("")) {
                object2 = ((MQTopic)topic).getBrokerPubQueueManager();
            }
            try {
                mQQueue = this.qm.accessQueue((String)object, n, (String)object2, null, null);
            }
            catch (MQException mQException) {
                if (Trace.isOn) {
                    Trace.trace(this, "createTProducer failed to access publish queue because of " + mQException);
                }
                JMSException jMSException = ConfigEnvironment.newException("MQJMS2008", object);
                jMSException.setLinkedException((Exception)mQException);
                throw jMSException;
            }
            mQMessageProducer = new MQMessageProducer((MQTopic)topic, mQQueue, this.qm, this.connection, this);
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception != null) {
                    Trace.trace(this, "linked exception " + exception);
                }
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createTProducer");
            }
        }
        return mQMessageProducer;
    }

    protected MQTopicPublisher createTPublisher(Topic topic) throws JMSException {
        MQTopicPublisher mQTopicPublisher;
        int n = 16;
        MQQueue mQQueue = null;
        Object object = null;
        try {
            String string;
            Object object2;
            if (Trace.isOn) {
                Trace.entry(this, "createTPublisher");
            }
            if (this.isClosed()) {
                String string2 = "MQJMS1024";
                String string3 = ConfigEnvironment.getErrorMessage(string2);
                throw new IllegalStateException(string3, string2);
            }
            this.addPubSubServices();
            object = this.connection.getBrkPubQueue();
            if (topic != null && topic instanceof MQTopic && (object2 = ((MQTopic)topic).getBrokerPubQueue()) != null && !((String)object2).equals("")) {
                object = object2;
            }
            if (topic != null && topic instanceof MQTopic && ((MQTopic)topic).getFailIfQuiesce() == 1) {
                n |= 0x2000;
            }
            if (this.qm == null) {
                object2 = ConfigEnvironment.newException("MQJMS2004");
                throw object2;
            }
            if (topic instanceof MQTemporaryTopic && ((MQTemporaryTopic)(object2 = (MQTemporaryTopic)topic)).isDeleted()) {
                JMSException jMSException = new JMSException("TemporaryTopic already deleted");
                throw jMSException;
            }
            object2 = this.brk.qmName;
            if (topic != null && topic instanceof MQTopic && (string = ((MQTopic)topic).getBrokerPubQueueManager()) != null && !string.equals("")) {
                object2 = ((MQTopic)topic).getBrokerPubQueueManager();
            }
            try {
                mQQueue = this.qm.accessQueue((String)object, n, (String)object2, null, null);
            }
            catch (MQException mQException) {
                if (Trace.isOn) {
                    Trace.trace(this, "createTPublisher failed to access publish queue because of " + mQException);
                }
                JMSException jMSException = ConfigEnvironment.newException("MQJMS2008", object);
                jMSException.setLinkedException((Exception)mQException);
                throw jMSException;
            }
            mQTopicPublisher = new MQTopicPublisher((MQTopic)topic, mQQueue, this.qm, this.connection, this);
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception != null) {
                    Trace.trace(this, "linked exception " + exception);
                }
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createTPublisher");
            }
        }
        return mQTopicPublisher;
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "createTemporaryTopic");
        }
        this.checkSessionOpen();
        this.addPubSubServices();
        if (Trace.isOn) {
            Trace.exit(this, "createTemporaryTopic");
        }
        return new MQTemporaryTopic(this.connection, this.connection.getAndIncrementTempTopicCount());
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        return this.createConsumer(destination, null);
    }

    public MessageConsumer createConsumer(Destination destination, String string) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "createConsumer");
        }
        try {
            if (this.isClosed()) {
                String string2 = "MQJMS1024";
                String string3 = ConfigEnvironment.getErrorMessage(string2);
                throw new IllegalStateException(string3, string2);
            }
            if (destination instanceof com.ibm.mq.jms.MQQueue) {
                MQMessageConsumer mQMessageConsumer = this.createQConsumer((com.ibm.mq.jms.MQQueue)destination, string);
                this.addConsumer(mQMessageConsumer);
                MQMessageConsumer mQMessageConsumer2 = mQMessageConsumer;
                return mQMessageConsumer2;
            }
            if (destination instanceof MQTopic) {
                MQMessageConsumer mQMessageConsumer = this.createTConsumer((MQTopic)destination, string, false);
                this.addConsumer(mQMessageConsumer);
                MQMessageConsumer mQMessageConsumer3 = mQMessageConsumer;
                return mQMessageConsumer3;
            }
            try {
                String string4 = "MQJMS0003";
                String string5 = ConfigEnvironment.getErrorMessage(string4);
                InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string5, string4);
                throw invalidDestinationException;
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                    Exception exception = jMSException.getLinkedException();
                    if (exception != null) {
                        Trace.trace(this, "linkedException " + exception);
                    }
                }
                throw jMSException;
            }
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createConsumer");
            }
        }
    }

    public MessageConsumer createConsumer(Destination destination, String string, boolean bl) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "createConsumer");
        }
        try {
            if (this.isClosed()) {
                String string2 = "MQJMS1024";
                String string3 = ConfigEnvironment.getErrorMessage(string2);
                throw new IllegalStateException(string3, string2);
            }
            if (destination instanceof com.ibm.mq.jms.MQQueue) {
                MQMessageConsumer mQMessageConsumer = this.createQConsumer((com.ibm.mq.jms.MQQueue)destination, string);
                this.addConsumer(mQMessageConsumer);
                MQMessageConsumer mQMessageConsumer2 = mQMessageConsumer;
                return mQMessageConsumer2;
            }
            if (destination instanceof MQTopic) {
                MQMessageConsumer mQMessageConsumer = this.createTConsumer((MQTopic)destination, string, bl);
                this.addConsumer(mQMessageConsumer);
                MQMessageConsumer mQMessageConsumer3 = mQMessageConsumer;
                return mQMessageConsumer3;
            }
            try {
                String string4 = "MQJMS0003";
                String string5 = ConfigEnvironment.getErrorMessage(string4);
                InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string5, string4);
                throw invalidDestinationException;
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                    Exception exception = jMSException.getLinkedException();
                    if (exception != null) {
                        Trace.trace(this, "linkedException " + exception);
                    }
                }
                throw jMSException;
            }
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createReceiver");
            }
        }
    }

    protected QueueReceiver createQReceiver(Queue queue, String string) throws JMSException {
        MQQueue mQQueue = null;
        try {
            MQQueueReceiver mQQueueReceiver;
            if (Trace.isOn) {
                Trace.entry(this, "createQReceiver");
            }
            this.addQueueServices();
            if (this.isClosed()) {
                String string2 = "MQJMS1024";
                String string3 = ConfigEnvironment.getErrorMessage(string2);
                IllegalStateException illegalStateException = new IllegalStateException(string3, string2);
                throw illegalStateException;
            }
            if (this.qm == null) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS2004");
                throw jMSException;
            }
            if (!(queue instanceof com.ibm.mq.jms.MQQueue)) {
                String string4 = "MQJMS0003";
                String string5 = ConfigEnvironment.getErrorMessage(string4);
                InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string5, string4);
                throw invalidDestinationException;
            }
            com.ibm.mq.jms.MQQueue mQQueue2 = (com.ibm.mq.jms.MQQueue)queue;
            if (Trace.isOn) {
                Trace.trace(this, "queueSpec: " + mQQueue2);
            }
            this.getServicesMgr().checkQueueAccess(mQQueue2, this);
            String string6 = mQQueue2.getBaseQueueName();
            String string7 = mQQueue2.getBaseQueueManagerName();
            if (!(string7 == null || string7.equals("") || string7.equals(this.resolvedQmName) || string7.equals(this.resolvedQSGName))) {
                if (Trace.isOn) {
                    Trace.trace(this, "qmgr " + string7 + " != " + this.resolvedQmName);
                }
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1017");
                throw jMSException;
            }
            int n = 137;
            n |= 0x20;
            int n2 = this.connection.getFailIfQuiesce();
            if (mQQueue2 != null) {
                n2 = mQQueue2.getFailIfQuiesce();
            }
            if (n2 == 1) {
                n |= 0x2000;
            }
            try {
                mQQueue = this.qm.accessQueue(string6, n);
            }
            catch (MQException mQException) {
                JMSException jMSException = this.getServicesMgr().getQueueOpenException(mQException);
                throw jMSException;
            }
            MQQueueReceiver mQQueueReceiver2 = mQQueueReceiver = new MQQueueReceiver(mQQueue2, string, mQQueue, this.transacted, this.acknowledgeMode, this);
            return mQQueueReceiver2;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Caught JMSException " + (Object)((Object)jMSException));
            }
            if (mQQueue != null) {
                try {
                    mQQueue.close();
                }
                catch (MQException mQException) {
                    // empty catch block
                }
            }
            if (Trace.isOn) {
                Trace.trace(this, "Passing on JMSException " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createQReceiever");
            }
        }
    }

    private MQMessageConsumer createQConsumer(Queue queue, String string) throws JMSException {
        MQQueue mQQueue = null;
        try {
            MQMessageConsumer mQMessageConsumer;
            if (Trace.isOn) {
                Trace.entry(this, "createQConsumer");
            }
            this.addQueueServices();
            if (this.isClosed()) {
                String string2 = "MQJMS1024";
                String string3 = ConfigEnvironment.getErrorMessage(string2);
                IllegalStateException illegalStateException = new IllegalStateException(string3, string2);
                throw illegalStateException;
            }
            if (this.qm == null) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS2004");
                throw jMSException;
            }
            if (!(queue instanceof com.ibm.mq.jms.MQQueue)) {
                String string4 = "MQJMS0003";
                String string5 = ConfigEnvironment.getErrorMessage(string4);
                InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string5, string4);
                throw invalidDestinationException;
            }
            com.ibm.mq.jms.MQQueue mQQueue2 = (com.ibm.mq.jms.MQQueue)queue;
            if (Trace.isOn) {
                Trace.trace(this, "queueSpec: " + mQQueue2);
            }
            this.getServicesMgr().checkQueueAccess(mQQueue2, this);
            String string6 = mQQueue2.getBaseQueueName();
            String string7 = mQQueue2.getBaseQueueManagerName();
            if (!(string7 == null || string7.equals("") || string7.equals(this.resolvedQmName) || string7.equals(this.resolvedQSGName))) {
                if (Trace.isOn) {
                    Trace.trace(this, "qmgr " + string7 + " != " + this.resolvedQmName);
                }
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1017");
                throw jMSException;
            }
            int n = 137;
            n |= 0x20;
            int n2 = this.connection.getFailIfQuiesce();
            if (mQQueue2 != null) {
                n2 = mQQueue2.getFailIfQuiesce();
            }
            if (n2 == 1) {
                n |= 0x2000;
            }
            try {
                mQQueue = this.qm.accessQueue(string6, n);
            }
            catch (MQException mQException) {
                JMSException jMSException = this.getServicesMgr().getQueueOpenException(mQException);
                throw jMSException;
            }
            MQMessageConsumer mQMessageConsumer2 = mQMessageConsumer = new MQMessageConsumer(mQQueue2, string, mQQueue, this.transacted, this.acknowledgeMode, this);
            return mQMessageConsumer2;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Caught JMSException " + (Object)((Object)jMSException));
            }
            if (mQQueue != null) {
                try {
                    mQQueue.close();
                }
                catch (MQException mQException) {
                    // empty catch block
                }
            }
            if (Trace.isOn) {
                Trace.trace(this, "Passing on JMSException " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createQConsumer");
            }
        }
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "createProducer");
        }
        try {
            if (this.isClosed()) {
                String string = "MQJMS1024";
                String string2 = ConfigEnvironment.getErrorMessage(string);
                throw new IllegalStateException(string2, string);
            }
            if (destination == null) {
                MQQueue mQQueue = null;
                String string = this.connection.getBrkPubQueue();
                if (this.qm == null) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS2004");
                    throw jMSException;
                }
                try {
                    mQQueue = this.qm.accessQueue(string, 16, this.brk.qmName, null, null);
                }
                catch (MQException mQException) {
                    if (Trace.isOn) {
                        Trace.trace(this, "createTProducer failed to access publish queue because of " + mQException);
                    }
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS2008", string);
                    jMSException.setLinkedException((Exception)mQException);
                    throw jMSException;
                }
                MQMessageProducer mQMessageProducer = new MQMessageProducer((MQDestination)destination, mQQueue, this.qm, this.connection, this);
                this.addProducer(mQMessageProducer);
                MQMessageProducer mQMessageProducer2 = mQMessageProducer;
                return mQMessageProducer2;
            }
            if (destination instanceof com.ibm.mq.jms.MQQueue) {
                MQMessageProducer mQMessageProducer = this.createQProducer((Queue)destination);
                this.addProducer(mQMessageProducer);
                MQMessageProducer mQMessageProducer3 = mQMessageProducer;
                return mQMessageProducer3;
            }
            if (destination instanceof MQTopic) {
                MQMessageProducer mQMessageProducer = (MQMessageProducer)this.createTProducer((Topic)destination);
                this.addProducer(mQMessageProducer);
                MQMessageProducer mQMessageProducer4 = mQMessageProducer;
                return mQMessageProducer4;
            }
            try {
                String string = "MQJMS0003";
                String string3 = ConfigEnvironment.getErrorMessage(string);
                InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string3, string);
                throw invalidDestinationException;
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                    Exception exception = jMSException.getLinkedException();
                    if (exception != null) {
                        Trace.trace(this, "linkedException " + exception);
                    }
                }
                throw jMSException;
            }
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createProducer");
            }
        }
    }

    protected QueueSender createQSender(Queue queue) throws JMSException {
        try {
            MQQueueSender mQQueueSender;
            com.ibm.mq.jms.MQQueue mQQueue = null;
            MQQueue mQQueue2 = null;
            if (Trace.isOn) {
                Trace.entry(this, "createQSender");
            }
            this.addQueueServices();
            if (this.isClosed()) {
                String string = "MQJMS1024";
                String string2 = ConfigEnvironment.getErrorMessage(string);
                IllegalStateException illegalStateException = new IllegalStateException(string2, string);
                throw illegalStateException;
            }
            if (this.qm == null) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS2004");
                throw jMSException;
            }
            if (queue != null) {
                if (!(queue instanceof com.ibm.mq.jms.MQQueue)) {
                    String string = "MQJMS0003";
                    String string3 = ConfigEnvironment.getErrorMessage(string);
                    InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string3, string);
                    throw invalidDestinationException;
                }
                mQQueue = (com.ibm.mq.jms.MQQueue)queue;
                mQQueue2 = this.getServicesMgr().getOutputQueue(mQQueue, this);
            }
            MQQueueSender mQQueueSender2 = mQQueueSender = new MQQueueSender(mQQueue, mQQueue2, this);
            return mQQueueSender2;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createQSender");
            }
        }
    }

    private MQMessageProducer createQProducer(Queue queue) throws JMSException {
        try {
            MQMessageProducer mQMessageProducer;
            com.ibm.mq.jms.MQQueue mQQueue = null;
            MQQueue mQQueue2 = null;
            if (Trace.isOn) {
                Trace.entry(this, "createQProducer");
            }
            this.addQueueServices();
            if (this.isClosed()) {
                String string = "MQJMS1024";
                String string2 = ConfigEnvironment.getErrorMessage(string);
                IllegalStateException illegalStateException = new IllegalStateException(string2, string);
                throw illegalStateException;
            }
            if (this.qm == null) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS2004");
                throw jMSException;
            }
            if (queue != null) {
                if (!(queue instanceof com.ibm.mq.jms.MQQueue)) {
                    String string = "MQJMS0003";
                    String string3 = ConfigEnvironment.getErrorMessage(string);
                    InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string3, string);
                    throw invalidDestinationException;
                }
                mQQueue = (com.ibm.mq.jms.MQQueue)queue;
                mQQueue2 = this.getServicesMgr().getOutputQueue(mQQueue, this);
            }
            MQMessageProducer mQMessageProducer2 = mQMessageProducer = new MQMessageProducer(mQQueue, mQQueue2, this);
            return mQMessageProducer2;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "createQProducer");
            }
        }
    }

    public final int getAcknowledgeMode() throws JMSException {
        if (Trace.isOn) {
            Trace.entryexit(this, "getAcknowledgeMode");
        }
        return this.transacted ? 0 : this.acknowledgeMode;
    }

    public void unsubscribe(String string) throws JMSException {
        this.checkSessionOpen();
        try {
            if (Trace.isOn) {
                Trace.entry(this, "unsubscribe");
                Trace.trace(this, "public unsubscribe call, name='" + string + "'");
            }
            this.addPubSubServices();
            MQSubscriptionEngine mQSubscriptionEngine = this.connection.getSubscriptionEngine();
            if (mQSubscriptionEngine != null) {
                mQSubscriptionEngine.durableUnsubscribe(this, string);
            }
        }
        catch (JMSException jMSException) {
            Throwable throwable = null;
            try {
                int n = Integer.parseInt(jMSException.getErrorCode());
                if (n == 3157) {
                    String string2 = "MQJMS3023";
                    String string3 = ConfigEnvironment.getErrorMessage(string2);
                    throwable = new IllegalStateException(string3, string2);
                    throwable.setLinkedException(jMSException.getLinkedException());
                } else {
                    throwable = jMSException;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throwable = jMSException;
            }
            if (Trace.isOn) {
                Trace.trace(this, "throwing " + throwable);
                Exception exception = throwable.getLinkedException();
                if (exception != null) {
                    Trace.trace(this, "linked exception = " + exception);
                }
            }
            throw throwable;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "unsubscribe");
            }
        }
    }

    protected void addQueueServices() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "addQueueServices()");
        }
        try {
            if (this.mqServices == null || !this.mqServices.queueSet) {
                this.mqServices = this.connection.getMQQueueServices(this.qm, this.transacted, this.acknowledgeMode);
            }
        }
        catch (JMSException jMSException) {
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "addQueueServices()");
            }
        }
    }

    protected JMSServicesMgr getServicesMgr() {
        if (this.connection == null) {
            Trace.trace(this, "Null Connection Value");
            return null;
        }
        return this.connection.getServicesMgr();
    }

    protected void addPubSubServices() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "addPubSubServices()");
        }
        try {
            this.mqServices = this.connection.getMQPubSubServices(this.transacted, this.acknowledgeMode, this);
            this.pubsubInit = true;
        }
        catch (JMSException jMSException) {
            throw jMSException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "addPubSubServices()");
            }
        }
    }

    protected void inhibitITX() throws JMSException {
        this.processDuration = 0;
        switch (this.getAcknowledgeMode()) {
            case 0: {
                this.rollback();
                break;
            }
            case 2: {
                this.recover();
                break;
            }
        }
        String string = "MQJMS0011";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        TransactionRolledBackException transactionRolledBackException = new TransactionRolledBackException(string2, string);
        throw transactionRolledBackException;
    }

    protected boolean supportsInherited() {
        block12: {
            if (this.distTransactionMode == 1 || this.distTransactionMode == 2) {
                this.ITXSupported = false;
            } else if (!this.ITXSupportChecked) {
                if (Trace.isOn) {
                    Trace.trace(this, "Haven't yet checked for session ITX support. Checking now");
                }
                try {
                    if (this.qm instanceof MQSPIQueueManager && ((MQSPIQueueManager)this.qm).spiSupportsInherited()) {
                        if (Trace.isOn) {
                            Trace.trace(this, "Queue manager supports ITX");
                        }
                        this.ITXSupported = true;
                        this.ITXSupportChecked = true;
                        break block12;
                    }
                    if (Trace.isOn) {
                        Trace.trace(this, "Queue manager doesn't support ITX");
                    }
                    this.ITXSupported = false;
                    this.ITXSupportChecked = true;
                }
                catch (MQException mQException) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Exception thrown checking for ITX support. Assuming not supported");
                        Trace.exception(this, "supportsInherited", (Throwable)mQException);
                    }
                    this.ITXSupported = false;
                    this.ITXSupportChecked = true;
                }
            } else if (Trace.isOn) {
                Trace.trace(this, "ITXSupport was previously checked. ITXSupported = " + this.ITXSupported);
            }
        }
        return this.ITXSupported;
    }
}

