/*
 * Copyright: Scheer E2E AG
 */
package ch.e2e.bridge.server.office;

import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.FormulaEvaluator;

@SuppressWarnings("UnusedDeclaration")
public class Cell {
    private int rowIndex;
    private int columnIndex;
    private String value;
    private int cellType;

    Cell(org.apache.poi.ss.usermodel.Cell poiCell, Workbook workbook) {
        rowIndex = poiCell.getRowIndex();
        columnIndex = poiCell.getColumnIndex();
        cellType = poiCell.getCellType().ordinal();
        setValue(poiCell, workbook.getFormatter(), workbook.getEvaluator());
    }

    public Cell() {
    }

    public int getRowIndex() {
        return rowIndex;
    }

    public void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    public int getColumnIndex() {
        return columnIndex;
    }

    public void setColumnIndex(int columnIndex) {
        this.columnIndex = columnIndex;
    }

    public int getCellType() {
        return cellType;
    }

    public void setCellType(int cellType) {
        this.cellType = cellType;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Cell cell = (Cell)o;
        return rowIndex == cell.rowIndex && columnIndex == cell.columnIndex;
    }

    @Override
    public int hashCode() {
        return 31 * rowIndex + columnIndex;
    }

    private void setValue(org.apache.poi.ss.usermodel.Cell poiCell, DataFormatter formatter, FormulaEvaluator evaluator) {
        value = formatter.formatCellValue(poiCell, evaluator);
    }
}
