/*
 * Copyright: Scheer E2E AG
 */
package ch.e2e.bridge.server.office;

import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.FormulaEvaluator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@SuppressWarnings("UnusedDeclaration")
public class Workbook {
    private int numberOfSheets;
    private List<Sheet> sheets;
    private FormulaEvaluator evaluator;
    private DataFormatter formatter;
    private boolean omitEmptyCells = true;

    Workbook(org.apache.poi.ss.usermodel.Workbook poiWorkbook, boolean omitEmptyCells) throws IOException {
        this.omitEmptyCells = omitEmptyCells;
        initialize(poiWorkbook);
    }

    Workbook(org.apache.poi.ss.usermodel.Workbook poiWorkbook) throws IOException {
        initialize(poiWorkbook);
    }

    public Workbook() {
    }

    public Sheet getSheet(String name) {
        for (Sheet sheet : sheets) {
            if (sheet.getSheetName().equals(name)) return sheet;
        }
        return null;
    }

    public Sheet getSheet(int number) {
        return sheets.get(number);
    }

    public List<Sheet> getSheets() {
        return sheets;
    }

    public void setSheets(List<Sheet> sheets) {
        this.sheets = sheets;
    }

    public int getNumberOfSheets() {
        return sheets.size();
    }

    public void setNumberOfSheets(int numberOfSheets) {
//	    this.numberOfSheets = numberOfSheets;
    }

    public boolean getOmitEmptyCells() {
        return omitEmptyCells;
    }

    public void setOmitEmptyCells(boolean omitEmptyCells) {
        this.omitEmptyCells = omitEmptyCells;
    }

    FormulaEvaluator getEvaluator() {
        return evaluator;
    }

    DataFormatter getFormatter() {
        return formatter;
    }

    private void initialize(org.apache.poi.ss.usermodel.Workbook poiWorkbook) throws IOException {
        try {
            numberOfSheets = poiWorkbook.getNumberOfSheets();
            sheets = new ArrayList<Sheet>(numberOfSheets);
            evaluator = poiWorkbook.getCreationHelper().createFormulaEvaluator();
            formatter = new DataFormatter();
            for (int i = 0; i < numberOfSheets; i++) {
                final org.apache.poi.ss.usermodel.Sheet poiSheet = poiWorkbook.getSheetAt(i);
                sheets.add(new Sheet(poiSheet, this));
            }
        } finally {
            poiWorkbook.close();
        }
    }
}
